/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.ext.snakeyaml;

import java.util.Objects;
import space.arim.dazzleconf.ext.snakeyaml.BasicWriter;
import space.arim.dazzleconf.ext.snakeyaml.CommentedWriter;
import space.arim.dazzleconf.ext.snakeyaml.FullWriter;
import space.arim.dazzleconf.ext.snakeyaml.YamlWriter;

public final class CommentMode {
    private final YamlWriter.Factory writerFactory;
    static final String DEFAULT_COMMENT_FORMAT = " # %s";

    CommentMode(YamlWriter.Factory writerFactory) {
        this.writerFactory = writerFactory;
    }

    YamlWriter.Factory writerFactory() {
        return this.writerFactory;
    }

    public boolean supportsComments() {
        return this.writerFactory().supportsComments();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommentMode that = (CommentMode)o;
        return this.writerFactory.equals(that.writerFactory);
    }

    public int hashCode() {
        return this.writerFactory.hashCode();
    }

    public String toString() {
        return "CommentMode{writerFactory=" + this.writerFactory + '}';
    }

    public static CommentMode headerOnly() {
        return new CommentMode(BasicWriter.Factory.INSTANCE);
    }

    public static CommentMode alternativeWriter(String commentFormat) {
        Objects.requireNonNull(commentFormat, "commentFormat");
        String.format(commentFormat, "dummy comment");
        return new CommentMode(new CommentedWriter.Factory(commentFormat));
    }

    public static CommentMode alternativeWriter() {
        return CommentMode.alternativeWriter(DEFAULT_COMMENT_FORMAT);
    }

    public static CommentMode fullComments() {
        return new CommentMode(FullWriter.Factory.INSTANCE);
    }
}

