/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.processor;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import space.arim.dazzleconf.ConfigurationOptions;
import space.arim.dazzleconf.error.BadValueException;
import space.arim.dazzleconf.internal.error.DeveloperError;
import space.arim.dazzleconf.internal.error.ElementaryType;
import space.arim.dazzleconf.internal.error.EnumType;
import space.arim.dazzleconf.internal.error.Errors;
import space.arim.dazzleconf.internal.error.UserError;
import space.arim.dazzleconf.internal.util.ImmutableCollections;
import space.arim.dazzleconf.serialiser.FlexibleType;
import space.arim.dazzleconf.serialiser.FlexibleTypeFunction;
import space.arim.dazzleconf.serialiser.FlexibleTypeMapEntryFunction;
import space.arim.dazzleconf.serialiser.ValueSerialiser;
import space.arim.dazzleconf.serialiser.ValueSerialiserMap;

final class FlexibleTypeImpl
implements FlexibleType {
    private final String key;
    private final Object value;
    private final transient ConfigurationOptions options;
    private final transient ValueSerialiserMap serialisers;

    FlexibleTypeImpl(String key, Object value, ConfigurationOptions options, ValueSerialiserMap serialisers) {
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
        this.options = Objects.requireNonNull(options, "options");
        this.serialisers = Objects.requireNonNull(serialisers, "serialisers");
    }

    @Override
    public String getAssociatedKey() {
        return this.key;
    }

    @Override
    public String getString() throws BadValueException {
        return this.value.toString();
    }

    @Override
    public boolean getBoolean() throws BadValueException {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.value instanceof String) {
            String parsable = (String)this.value;
            if (parsable.equalsIgnoreCase("true") || parsable.equalsIgnoreCase("yes")) {
                return true;
            }
            if (parsable.equalsIgnoreCase("false") || parsable.equalsIgnoreCase("no")) {
                return false;
            }
        }
        throw this.badValueExceptionBuilder().message(UserError.wrongType(ElementaryType.BOOLEAN, this.value)).build();
    }

    @Override
    public byte getByte() throws BadValueException {
        return this.getNumber().byteValue();
    }

    @Override
    public short getShort() throws BadValueException {
        return this.getNumber().shortValue();
    }

    @Override
    public int getInteger() throws BadValueException {
        return this.getNumber().intValue();
    }

    @Override
    public long getLong() throws BadValueException {
        return this.getNumber().longValue();
    }

    @Override
    public float getFloat() throws BadValueException {
        return this.getNumber().floatValue();
    }

    @Override
    public double getDouble() throws BadValueException {
        return this.getNumber().doubleValue();
    }

    private Number getNumber() throws BadValueException {
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        if (this.value instanceof String) {
            Number parsed;
            try {
                parsed = NumberFormat.getInstance().parse((String)this.value);
            }
            catch (ParseException ex) {
                throw this.badValueExceptionBuilder().message(UserError.wrongType(ElementaryType.NUMBER, this.value).withExtraInfo("Attempted to convert to a number, but failed")).cause(ex).build();
            }
            return parsed;
        }
        throw this.badValueExceptionBuilder().message(UserError.wrongType(ElementaryType.NUMBER, this.value)).build();
    }

    @Override
    public char getCharacter() throws BadValueException {
        if (this.value instanceof Character) {
            return ((Character)this.value).charValue();
        }
        String string = this.getString();
        if (string.length() != 1) {
            throw this.badValueExceptionBuilder().message(UserError.wrongType(ElementaryType.CHARACTER, this.value)).build();
        }
        return string.charAt(0);
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> enumClass) throws BadValueException {
        Objects.requireNonNull(enumClass, "enumClass");
        if (enumClass.isInstance(this.value)) {
            return (T)((Enum)enumClass.cast(this.value));
        }
        String parsable = this.getString();
        boolean strictParseEnums = this.options.strictParseEnums();
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            boolean equal;
            String name = enumConstant.name();
            boolean bl = equal = strictParseEnums ? name.equals(parsable) : name.equalsIgnoreCase(parsable);
            if (!equal) continue;
            return (T)enumConstant;
        }
        throw this.badValueExceptionBuilder().message(UserError.wrongType(new EnumType(enumClass), this.value)).build();
    }

    private <T, E extends Enum<E>> T getEnumUnchecked(Class<T> enumClass) throws BadValueException {
        return enumClass.cast(this.getEnum(enumClass));
    }

    @Override
    public List<FlexibleType> getList() throws BadValueException {
        return this.getList(flexType -> flexType);
    }

    @Override
    public <E> List<E> getList(FlexibleTypeFunction<? extends E> elementProcessor) throws BadValueException {
        return (List)this.getCollection0(true, elementProcessor);
    }

    @Override
    public Set<FlexibleType> getSet() throws BadValueException {
        return this.getSet(flexType -> flexType);
    }

    @Override
    public <E> Set<E> getSet(FlexibleTypeFunction<? extends E> elementProcessor) throws BadValueException {
        return (Set)this.getCollection0(false, elementProcessor);
    }

    @Override
    public Collection<FlexibleType> getCollection() throws BadValueException {
        return this.getCollection(flexType -> flexType);
    }

    @Override
    public <E> Collection<E> getCollection(FlexibleTypeFunction<? extends E> elementProcessor) throws BadValueException {
        return this.getCollection0(false, elementProcessor);
    }

    private <E> Collection<E> getCollection0(boolean ordered, FlexibleTypeFunction<? extends E> elementProcessor) throws BadValueException {
        Objects.requireNonNull(elementProcessor, "elementProcessor");
        if (!(this.value instanceof Collection)) {
            if (this.options.createSingleElementCollections()) {
                E singleResult = elementProcessor.getResult(this);
                return ordered ? ImmutableCollections.listOf(singleResult) : ImmutableCollections.setOf(singleResult);
            }
            throw this.badValueExceptionBuilder().message(UserError.wrongType(ElementaryType.LIST, this.value)).build();
        }
        Collection collection = (Collection)this.value;
        AbstractCollection result = ordered ? new ArrayList(collection.size()) : new HashSet(collection.size());
        for (Object element : collection) {
            result.add(elementProcessor.getResult(this.deriveFlexibleObject(element)));
        }
        return ordered ? ImmutableCollections.listOf(result) : ImmutableCollections.setOf(result);
    }

    @Override
    public Map<FlexibleType, FlexibleType> getMap() throws BadValueException {
        return this.getMap(ImmutableCollections::mapEntryOf);
    }

    @Override
    public <K, V> Map<K, V> getMap(FlexibleTypeMapEntryFunction<? extends K, ? extends V> entryProcessor) throws BadValueException {
        Objects.requireNonNull(entryProcessor, "entryProcessor");
        if (!(this.value instanceof Map)) {
            throw this.badValueExceptionBuilder().message(UserError.wrongType(ElementaryType.SECTION, this.value)).build();
        }
        Map map = (Map)this.value;
        HashMap<K, V> result = new HashMap<K, V>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            Map.Entry<K, V> processed = entryProcessor.getResult(this.deriveFlexibleObject(entry.getKey()), this.deriveFlexibleObject(entry.getValue()));
            result.put(processed.getKey(), processed.getValue());
        }
        return ImmutableCollections.mapOf(result);
    }

    private FlexibleTypeImpl deriveFlexibleObject(Object value) throws BadValueException {
        if (value == null) {
            throw this.badValueExceptionBuilder().message(UserError.nullValue(this.key)).build();
        }
        return new FlexibleTypeImpl(this.key, value, this.options, this.serialisers);
    }

    @Override
    public <T> T getObject(Class<T> clazz) throws BadValueException {
        return (T)this.getObject0(Objects.requireNonNull(clazz, "clazz"));
    }

    private <G> Object getObject0(Class<G> goal) throws BadValueException {
        if (goal == Object.class) {
            return this.value;
        }
        if (goal == Boolean.TYPE || goal == Boolean.class) {
            return this.getBoolean();
        }
        if (goal == String.class) {
            return this.getString();
        }
        if (goal == Character.TYPE || goal == Character.class) {
            return Character.valueOf(this.getCharacter());
        }
        if (goal == Number.class) {
            return this.getNumber();
        }
        if (goal == Integer.TYPE || goal == Integer.class) {
            return this.getInteger();
        }
        if (goal == Long.TYPE || goal == Long.class) {
            return this.getLong();
        }
        if (goal == Short.TYPE || goal == Short.class) {
            return this.getShort();
        }
        if (goal == Byte.TYPE || goal == Byte.class) {
            return this.getByte();
        }
        if (goal == Double.TYPE || goal == Double.class) {
            return this.getDouble();
        }
        if (goal == Float.TYPE || goal == Float.class) {
            return Float.valueOf(this.getFloat());
        }
        if (goal.isEnum()) {
            return this.getEnumUnchecked(goal);
        }
        if (goal.isInstance(this.value)) {
            return goal.cast(this.value);
        }
        return goal.cast(this.fromSerialiser(this.getSerialiser(goal)));
    }

    private <G> ValueSerialiser<G> getSerialiser(Class<G> goal) {
        ValueSerialiser serialiser = this.serialisers.getSerialiserFor(goal).orElse(null);
        if (serialiser == null) {
            throw DeveloperError.noSerializerFound(Errors.When.LOAD_CONFIG, this.key, goal).toConfigException();
        }
        return serialiser;
    }

    private <G> G fromSerialiser(ValueSerialiser<G> serialiser) throws BadValueException {
        G deserialised = serialiser.deserialise(this);
        if (deserialised == null) {
            throw DeveloperError.serializerReturnedNull(Errors.When.LOAD_CONFIG, this.key, serialiser).toConfigException();
        }
        return deserialised;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FlexibleTypeImpl)) {
            return false;
        }
        FlexibleTypeImpl other = (FlexibleTypeImpl)object;
        return this.key.equals(other.key) && this.value.equals(other.value);
    }

    public String toString() {
        return "FlexibleTypeImpl [key=" + this.key + ", value=" + this.value + "]";
    }
}

