/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.processor;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import space.arim.dazzleconf.internal.processor.ConfigInvocationHandler;
import space.arim.dazzleconf.internal.util.ImmutableCollections;
import space.arim.dazzleconf.internal.util.MethodUtil;

class DefaultMethodConfigInvocationHandler
extends ConfigInvocationHandler {
    private Map<Method, MethodHandle> defaultMethodsMap;

    DefaultMethodConfigInvocationHandler(Map<String, Object> configMap) {
        super(configMap);
    }

    void initDefaultMethods(Object proxy, Set<Method> defaultMethods) {
        this.defaultMethodsMap = DefaultMethodConfigInvocationHandler.buildDefaultMethodsMap(proxy, defaultMethods);
    }

    private static Map<Method, MethodHandle> buildDefaultMethodsMap(Object proxy, Set<Method> defaultMethods) {
        HashMap<Method, MethodHandle> result = new HashMap<Method, MethodHandle>(defaultMethods.size());
        for (Method method : defaultMethods) {
            MethodHandle methodHandle = MethodUtil.createDefaultMethodHandle(method).bindTo(proxy);
            result.put(method, methodHandle);
        }
        return ImmutableCollections.mapOf(result);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() != Object.class && MethodUtil.isDefault(method)) {
            return this.defaultMethodsMap.get(method).invokeWithArguments(args);
        }
        return super.invoke(proxy, method, args);
    }
}

