/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.error;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import space.arim.dazzleconf.internal.error.UserType;

public enum ElementaryType implements UserType
{
    BOOLEAN,
    NUMBER,
    CHARACTER,
    STRING,
    LIST,
    SECTION;


    public static ElementaryType fromElementaryObject(Object obj) {
        Objects.requireNonNull(obj, "obj");
        if (obj instanceof Boolean) {
            return BOOLEAN;
        }
        if (obj instanceof Number) {
            return NUMBER;
        }
        if (obj instanceof Character) {
            return CHARACTER;
        }
        if (obj instanceof String) {
            return STRING;
        }
        if (obj instanceof List || obj instanceof Set) {
            return LIST;
        }
        if (obj instanceof Map) {
            return SECTION;
        }
        throw new IllegalArgumentException("Found elementary object " + obj + " which is unexpectedly a " + obj.getClass());
    }

    @Override
    public String[] examples() {
        switch (this) {
            case BOOLEAN: {
                return new String[]{"true", "false"};
            }
            case NUMBER: {
                return new String[]{"1", "14.23", "-2"};
            }
            case CHARACTER: {
                return new String[]{"'a'", "'f'", "'z'"};
            }
            case STRING: {
                return new String[]{"'hello everyone'", "'good fortune shines upon us'"};
            }
            case LIST: {
                return new String[0];
            }
            case SECTION: {
                return new String[0];
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String toString() {
        switch (this) {
            case BOOLEAN: {
                return "a true/false value";
            }
            case NUMBER: {
                return "a numerical value";
            }
            case CHARACTER: {
                return "a single character";
            }
            case STRING: {
                return "a text value";
            }
            case LIST: {
                return "a list or group of values";
            }
            case SECTION: {
                return "a configuration section";
            }
        }
        throw new IllegalArgumentException();
    }
}

