/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.factory;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Objects;
import space.arim.dazzleconf.ConfigurationFactory;
import space.arim.dazzleconf.ConfigurationOptions;
import space.arim.dazzleconf.error.InvalidConfigException;

@Deprecated
public abstract class BaseConfigurationFactory<C>
implements ConfigurationFactory<C> {
    private final Class<C> configClass;
    private final ConfigurationOptions options;

    protected BaseConfigurationFactory(Class<C> configClass, ConfigurationOptions options) {
        Objects.requireNonNull(configClass, "configClazz");
        if (!configClass.isInterface()) {
            throw new IllegalArgumentException(configClass.getName() + " is not an interface");
        }
        this.configClass = configClass;
        this.options = Objects.requireNonNull(options, "options");
    }

    @Override
    public Class<C> getConfigClass() {
        return this.configClass;
    }

    @Override
    public ConfigurationOptions getOptions() {
        return this.options;
    }

    protected abstract Charset charset();

    protected abstract C loadFromReader(Reader var1) throws IOException, InvalidConfigException;

    protected abstract C loadFromReader(Reader var1, C var2) throws IOException, InvalidConfigException;

    private C loadConfig(Reader reader) throws IOException, InvalidConfigException {
        try (Reader reader0 = reader;){
            C c;
            try (BufferedReader buffReader = new BufferedReader(reader0);){
                c = this.loadFromReader(buffReader);
            }
            return c;
        }
    }

    private C loadConfig(Reader reader, C auxiliaryEntries) throws IOException, InvalidConfigException {
        try (Reader reader0 = reader;){
            C c;
            try (BufferedReader buffReader = new BufferedReader(reader0);){
                c = this.loadFromReader(buffReader, auxiliaryEntries);
            }
            return c;
        }
    }

    private Reader toReader(ReadableByteChannel readChannel) {
        return Channels.newReader(readChannel, this.charset().newDecoder(), -1);
    }

    private Reader toReader(InputStream inputStream) {
        return new InputStreamReader(inputStream, this.charset());
    }

    @Override
    public C load(ReadableByteChannel readChannel) throws IOException, InvalidConfigException {
        return this.loadConfig(this.toReader(readChannel));
    }

    @Override
    public C load(InputStream inputStream) throws IOException, InvalidConfigException {
        return this.loadConfig(this.toReader(inputStream));
    }

    @Override
    public C load(ReadableByteChannel readChannel, C auxiliaryEntries) throws IOException, InvalidConfigException {
        this.configClass.cast(Objects.requireNonNull(auxiliaryEntries, "auxiliaryEntries"));
        return this.loadConfig(this.toReader(readChannel), auxiliaryEntries);
    }

    @Override
    public C load(InputStream inputStream, C auxiliaryEntries) throws IOException, InvalidConfigException {
        this.configClass.cast(Objects.requireNonNull(auxiliaryEntries, "auxiliaryEntries"));
        return this.loadConfig(this.toReader(inputStream), auxiliaryEntries);
    }

    protected abstract void writeToWriter(C var1, Writer var2) throws IOException;

    private void writeConfig(C configData, Writer writer) throws IOException {
        try (Writer writer0 = writer;
             BufferedWriter buffWriter = new BufferedWriter(writer0);){
            this.writeToWriter(configData, buffWriter);
        }
    }

    @Override
    public void write(C configData, WritableByteChannel writableChannel) throws IOException {
        this.configClass.cast(Objects.requireNonNull(configData, "configData"));
        this.writeConfig(configData, Channels.newWriter(writableChannel, this.charset().newEncoder(), -1));
    }

    @Override
    public void write(C configData, OutputStream outputStream) throws IOException {
        this.configClass.cast(Objects.requireNonNull(configData, "configData"));
        this.writeConfig(configData, new OutputStreamWriter(outputStream, this.charset()));
    }
}

