/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.processor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import space.arim.dazzleconf.error.IllDefinedConfigException;
import space.arim.dazzleconf.error.InvalidConfigException;
import space.arim.dazzleconf.internal.ConfEntry;
import space.arim.dazzleconf.internal.processor.DefaultsProcessor;
import space.arim.dazzleconf.internal.processor.ProcessorBase;
import space.arim.dazzleconf.internal.type.ReturnType;
import space.arim.dazzleconf.internal.type.ReturnTypeWithConfigDefinition;
import space.arim.dazzleconf.internal.util.AccessChecking;
import space.arim.dazzleconf.internal.util.MethodUtil;

class DefaultObjectHelper {
    private final ConfEntry entry;
    private final ProcessorBase<?> processor;

    DefaultObjectHelper(ConfEntry entry, ProcessorBase<?> processor) {
        this.entry = entry;
        this.processor = processor;
    }

    private String reasonToExceptionMessage(String reason) {
        return "Encountered an issue with the defaults annotation on " + this.entry.getQualifiedMethodName() + ". Reason: " + reason;
    }

    IllDefinedConfigException badDefault(String reason) {
        return new IllDefinedConfigException(this.reasonToExceptionMessage(reason));
    }

    private IllDefinedConfigException badDefault(String reason, Throwable cause) {
        return new IllDefinedConfigException(this.reasonToExceptionMessage(reason), cause);
    }

    Map<String, String> toMap(String ... values) {
        HashMap<String, String> result = new HashMap<String, String>();
        String key = null;
        for (String value : values) {
            if (key == null) {
                key = value;
                continue;
            }
            result.put(key, value);
            key = null;
        }
        if (key != null) {
            throw this.badDefault("@DefaultMap must consist of key-value pairs. (Therefore, it must have an even number of strings)");
        }
        return result;
    }

    private Method locateMethod(String fullyQualifiedMethodName) {
        String methodName;
        Class<?> clazz;
        int index = fullyQualifiedMethodName.lastIndexOf(46);
        if (index == -1) {
            clazz = this.entry.getMethod().getDeclaringClass();
            methodName = fullyQualifiedMethodName;
        } else {
            if (index == fullyQualifiedMethodName.length() - 1) {
                throw this.badDefault("A malformed method name " + fullyQualifiedMethodName + " was specified by @DefaultObject. Please ensure the value of @DefaultObject is a fully qualified method name.");
            }
            String className = fullyQualifiedMethodName.substring(0, index);
            methodName = fullyQualifiedMethodName.substring(index + 1);
            Class<?> configClass = this.entry.getMethod().getDeclaringClass();
            try {
                clazz = Class.forName(className, true, configClass.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw this.badDefault("Class " + className + " specified by @DefaultObject cannot be found", ex);
            }
            if (!AccessChecking.isAccessible(clazz)) {
                throw this.badDefault("Method " + fullyQualifiedMethodName + " must be in an accessible class. The class specified is inaccessible.");
            }
        }
        try {
            return clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            NoSuchMethodException attemptOneEx = ex;
            ReturnType<?> returnType = this.entry.returnType();
            if (!(returnType instanceof ReturnTypeWithConfigDefinition)) {
                throw this.badDefault("The method " + methodName + " (with no parameters) does not exist in class " + clazz.getName(), attemptOneEx);
            }
            Class configClass = ((ReturnTypeWithConfigDefinition)returnType).configDefinition().getConfigClass();
            try {
                return clazz.getDeclaredMethod(methodName, configClass);
            }
            catch (NoSuchMethodException ex2) {
                ex2.addSuppressed(attemptOneEx);
                throw this.badDefault("The method " + methodName + " (with acceptable parameters) does not exist in class " + clazz.getName(), ex2);
            }
        }
    }

    Object toObject(String methodName) throws InvalidConfigException {
        Class<?> targetType = this.entry.returnType().typeInfo().rawType();
        if (targetType.isPrimitive() || targetType.equals(String.class)) {
            throw new IllDefinedConfigException("@DefaultObject cannot be used for primitives or strings. Use one of @DefaultBoolean for boolean, @DefaultInteger for int/short/byte, @DefaultLong for long, @DefaultDouble for double/float, or @DefaultString for String/char");
        }
        Method method = this.locateMethod(methodName);
        int modifiers = method.getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw this.badDefault("The method " + MethodUtil.getQualifiedName(method) + " must be public and static");
        }
        method.setAccessible(true);
        Object result = this.fromMethod(method);
        if (result == null) {
            throw this.badDefault("The object returned from @DefaultObject was null");
        }
        if (!targetType.isInstance(result)) {
            throw this.badDefault("The object returned from @DefaultObject must be an instance of the return type of the config method. However, " + result + " was received");
        }
        return result;
    }

    private Object fromMethod(Method method) throws InvalidConfigException {
        if (method.getParameterCount() == 0) {
            return this.invokeStaticMethod(method, new Object[0]);
        }
        ReturnTypeWithConfigDefinition returnType = (ReturnTypeWithConfigDefinition)this.entry.returnType();
        Object config = this.processor.createNested(this.entry, returnType, DefaultsProcessor.CREATE_DEFAULT_SECTION);
        return this.invokeStaticMethod(method, config);
    }

    private Object invokeStaticMethod(Method method, Object ... args) {
        try {
            return method.invoke(null, args);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw this.badDefault("Exception invoking method " + MethodUtil.getQualifiedName(method), ex);
        }
    }
}

