/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.deprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import space.arim.dazzleconf.error.IllDefinedConfigException;
import space.arim.dazzleconf.internal.error.DeveloperError;
import space.arim.dazzleconf.internal.error.Errors;
import space.arim.dazzleconf.serialiser.Decomposer;
import space.arim.dazzleconf.serialiser.ValueSerialiser;
import space.arim.dazzleconf.serialiser.ValueSerialiserMap;

class DecomposerImpl
implements Decomposer {
    private final String key;
    private final ValueSerialiserMap serialisers;

    DecomposerImpl(String key, ValueSerialiserMap serialisers) {
        this.key = key;
        this.serialisers = serialisers;
    }

    @Override
    public <T> Object decompose(Class<T> clazz, T value) {
        if (clazz == Collection.class || clazz == List.class || clazz == Set.class || clazz == Map.class) {
            throw new IllDefinedConfigException("Cannot serialise to a collection or map via Decomposer#decompose. Use #decomposeCollection, #decomposeMap, or serialise each element instead.");
        }
        if (clazz == Character.TYPE) {
            return value.toString();
        }
        if (clazz.isPrimitive()) {
            return value;
        }
        clazz.cast(value);
        if (value instanceof String || value instanceof Boolean || value instanceof Number) {
            return value;
        }
        if (value instanceof Character) {
            return value.toString();
        }
        if (clazz.isEnum()) {
            return ((Enum)value).name();
        }
        return this.fromSerialiser(this.getSerialiser(clazz), value);
    }

    private <T> ValueSerialiser<T> getSerialiser(Class<T> clazz) {
        ValueSerialiser serialiser = this.serialisers.getSerialiserFor(clazz).orElse(null);
        if (serialiser == null) {
            throw DeveloperError.noSerializerFound(Errors.When.WRITE_CONFIG, this.key, clazz).toConfigException();
        }
        return serialiser;
    }

    private <T> Object fromSerialiser(ValueSerialiser<T> serialiser, T value) {
        Object serialised = serialiser.serialise(value, this);
        if (serialised == null) {
            throw DeveloperError.serializerReturnedNull(Errors.When.WRITE_CONFIG, this.key, serialiser).toConfigException();
        }
        return serialised;
    }

    @Override
    public <E> Collection<Object> decomposeCollection(Class<E> elementType, Collection<? extends E> collection) {
        ArrayList<Object> serialised = new ArrayList<Object>(collection.size());
        for (E element : collection) {
            serialised.add(this.decompose(elementType, element));
        }
        return serialised;
    }

    @Override
    public <K, V> Map<Object, Object> decomposeMap(Class<K> keyType, Class<V> valueType, Map<? extends K, ? extends V> map) {
        LinkedHashMap<Object, Object> serialised = new LinkedHashMap<Object, Object>((int)((float)map.size() / 0.74f));
        for (Map.Entry<K, V> mapEntry : map.entrySet()) {
            serialised.put(this.decompose(keyType, mapEntry.getKey()), this.decompose(valueType, mapEntry.getValue()));
        }
        return serialised;
    }
}

