/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.factory;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import space.arim.dazzleconf.ConfigurationOptions;
import space.arim.dazzleconf.error.InvalidConfigException;
import space.arim.dazzleconf.factory.ConfigurationFormatFactory;

public abstract class HumanReadableConfigurationFactory<C>
extends ConfigurationFormatFactory<C> {
    protected HumanReadableConfigurationFactory(Class<C> configClass, ConfigurationOptions options) {
        super(configClass, options);
    }

    public abstract Charset charset();

    @Override
    public final Map<String, Object> loadMap(ReadableByteChannel readChannel) throws IOException, InvalidConfigException {
        return this.bufferedLoadMap(Channels.newReader(readChannel, this.charset().newDecoder(), -1));
    }

    @Override
    public final Map<String, Object> loadMap(InputStream inputStream) throws IOException, InvalidConfigException {
        return this.bufferedLoadMap(new InputStreamReader(inputStream, this.charset()));
    }

    private Map<String, Object> bufferedLoadMap(Reader reader) throws IOException, InvalidConfigException {
        Map<String, Object> map;
        try (Reader unbuffered = reader;
             BufferedReader buffered = new BufferedReader(unbuffered);){
            map = this.loadMap(buffered);
        }
        return Objects.requireNonNull(map, "Subclass returned null map from #loadMap");
    }

    public abstract Map<String, Object> loadMap(Reader var1) throws IOException, InvalidConfigException;

    @Override
    public final void writeMap(Map<String, Object> config, WritableByteChannel writeChannel) throws IOException {
        this.bufferedWriteMap(config, Channels.newWriter(writeChannel, this.charset().newEncoder(), -1));
    }

    @Override
    public final void writeMap(Map<String, Object> config, OutputStream outputStream) throws IOException {
        this.bufferedWriteMap(config, new OutputStreamWriter(outputStream, this.charset()));
    }

    private void bufferedWriteMap(Map<String, Object> config, Writer writer) throws IOException {
        try (Writer unbuffered = writer;
             BufferedWriter buffered = new BufferedWriter(unbuffered);){
            this.writeMap(config, buffered);
        }
    }

    public abstract void writeMap(Map<String, Object> var1, Writer var2) throws IOException;
}

