/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ImmutableCollections {
    private static final boolean PRE_JAVA_10;

    private ImmutableCollections() {
    }

    public static <E> List<E> emptyList() {
        if (PRE_JAVA_10) {
            return Collections.emptyList();
        }
        return List.of();
    }

    public static <E> List<E> listOf(E element) {
        if (PRE_JAVA_10) {
            Objects.requireNonNull(element, "element");
            return Collections.singletonList(element);
        }
        return List.of(element);
    }

    @SafeVarargs
    public static <E> List<E> listOf(E ... elements) {
        if (PRE_JAVA_10) {
            for (Object element : elements = (Object[])elements.clone()) {
                Objects.requireNonNull(element, "element");
            }
            return Collections.unmodifiableList(Arrays.asList(elements));
        }
        return List.of(elements);
    }

    public static <E> List<E> listOf(Collection<? extends E> coll) {
        if (PRE_JAVA_10) {
            return ImmutableCollections.listOf(coll.toArray());
        }
        return List.copyOf(coll);
    }

    public static <E> Set<E> emptySet() {
        if (PRE_JAVA_10) {
            return Collections.emptySet();
        }
        return Set.of();
    }

    public static <E> Set<E> setOf(E element) {
        if (PRE_JAVA_10) {
            Objects.requireNonNull(element, "element");
            return Collections.singleton(element);
        }
        return Set.of(element);
    }

    public static <E> Set<E> setOf(Collection<? extends E> coll) {
        if (PRE_JAVA_10) {
            HashSet<E> hashSet = new HashSet<E>(coll);
            for (Object element : hashSet) {
                Objects.requireNonNull(element, "element");
            }
            return Collections.unmodifiableSet(hashSet);
        }
        return Set.copyOf(coll);
    }

    public static <K, V> Map<K, V> emptyMap() {
        if (PRE_JAVA_10) {
            return Collections.emptyMap();
        }
        return Map.of();
    }

    public static <K, V> Map<K, V> mapOf(Map<? extends K, ? extends V> map) {
        if (PRE_JAVA_10) {
            HashMap<K, V> hashMap = new HashMap<K, V>(map);
            for (Map.Entry entry : hashMap.entrySet()) {
                Objects.requireNonNull(entry.getKey(), "key");
                Objects.requireNonNull(entry.getValue(), "value");
            }
            return Collections.unmodifiableMap(hashMap);
        }
        return Map.copyOf(map);
    }

    public static <K, V> Map.Entry<K, V> mapEntryOf(K key, V value) {
        if (PRE_JAVA_10) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
            return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
        }
        return Map.entry(key, value);
    }

    static {
        boolean preJava10 = false;
        try {
            List.copyOf(List.of());
        }
        catch (NoSuchMethodError nsme) {
            preJava10 = true;
        }
        PRE_JAVA_10 = preJava10;
    }
}

