/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import space.arim.dazzleconf.internal.ConfEntry;

public class ConfigurationInvoker<C> {
    private final C configData;
    private final transient InvocationHandler proxyHandler;

    public ConfigurationInvoker(C configData) {
        this.configData = configData;
        this.proxyHandler = Proxy.isProxyClass(configData.getClass()) ? Proxy.getInvocationHandler(configData) : null;
    }

    public Object getEntryValue(ConfEntry entry) {
        Object value;
        Method method = entry.getMethod();
        try {
            value = this.proxyHandler != null ? this.proxyHandler.invoke(this.configData, method, null) : method.invoke(this.configData, new Object[0]);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Exception while invoking implementation of " + entry.getQualifiedMethodName() + " in " + this.configData.getClass().getName(), ex);
        }
        if (value == null) {
            throw new NullPointerException(entry.getQualifiedMethodName() + " implementation in " + this.configData.getClass() + " returned null");
        }
        return value;
    }
}

