/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.type;

import java.util.Collection;
import java.util.Objects;
import space.arim.dazzleconf.internal.ConfigurationDefinition;
import space.arim.dazzleconf.internal.type.CollectionKind;
import space.arim.dazzleconf.internal.type.CollectionReturnType;
import space.arim.dazzleconf.internal.type.ReturnTypeWithConfigDefinition;
import space.arim.dazzleconf.internal.type.TypeInfo;

public final class SubSectionCollectionReturnType<E, R extends Collection<E>>
implements CollectionReturnType<E, R>,
ReturnTypeWithConfigDefinition<E, R> {
    private final TypeInfo<R> typeInfo;
    private final ConfigurationDefinition<E> configDefinition;

    public SubSectionCollectionReturnType(TypeInfo<R> typeInfo, ConfigurationDefinition<E> configDefinition) {
        CollectionKind.fromType(typeInfo);
        this.typeInfo = Objects.requireNonNull(typeInfo, "type info");
        this.configDefinition = Objects.requireNonNull(configDefinition, "config definition");
    }

    @Override
    public TypeInfo<R> typeInfo() {
        return this.typeInfo;
    }

    @Override
    public ConfigurationDefinition<E> configDefinition() {
        return this.configDefinition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubSectionCollectionReturnType that = (SubSectionCollectionReturnType)o;
        return this.typeInfo.equals(that.typeInfo) && this.configDefinition.equals(that.configDefinition);
    }

    public int hashCode() {
        int result = this.typeInfo.hashCode();
        result = 31 * result + this.configDefinition.hashCode();
        return result;
    }

    public String toString() {
        return "SubSectionCollectionReturnType{typeInfo=" + this.typeInfo + ", configDefinition=" + this.configDefinition + '}';
    }
}

