/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.type;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import space.arim.dazzleconf.annote.SubSection;
import space.arim.dazzleconf.error.IllDefinedConfigException;
import space.arim.dazzleconf.internal.DefinitionReader;
import space.arim.dazzleconf.internal.type.CollectionKind;
import space.arim.dazzleconf.internal.type.CollectionReturnType;
import space.arim.dazzleconf.internal.type.MapReturnType;
import space.arim.dazzleconf.internal.type.ReturnType;
import space.arim.dazzleconf.internal.type.SimpleCollectionReturnType;
import space.arim.dazzleconf.internal.type.SimpleMapReturnType;
import space.arim.dazzleconf.internal.type.SimpleSubSectionReturnType;
import space.arim.dazzleconf.internal.type.SimpleTypeReturnType;
import space.arim.dazzleconf.internal.type.SubSectionCollectionReturnType;
import space.arim.dazzleconf.internal.type.SubSectionMapReturnType;
import space.arim.dazzleconf.internal.type.TypeInfo;
import space.arim.dazzleconf.internal.util.MethodUtil;

public class ReturnTypeCreation {
    private final DefinitionReader<?> reader;
    private final TypeInfo<?> returnTypeInfo;

    public ReturnTypeCreation(DefinitionReader<?> reader, TypeInfo<?> returnTypeInfo) {
        this.reader = reader;
        this.returnTypeInfo = returnTypeInfo;
    }

    public ReturnType<?> create(Method method) {
        try {
            return this.createUsingFakeGenerics(method);
        }
        catch (IllDefinedConfigException ex) {
            throw new IllDefinedConfigException("Unable to analyze return type of " + MethodUtil.getQualifiedName(method), ex);
        }
    }

    private <F1, F2 extends Collection<F1>> ReturnType<?> createUsingFakeGenerics(Method method) {
        if (CollectionKind.isCollectionOrSubclass(this.returnTypeInfo)) {
            TypeInfo<?> casted = this.returnTypeInfo;
            return this.makeCollectionReturnType(casted);
        }
        if (this.returnTypeInfo.rawType().equals(Map.class)) {
            TypeInfo casted = this.returnTypeInfo;
            return this.makeMapReturnType(casted);
        }
        return this.makeSimpleReturnType(this.returnTypeInfo, method.isAnnotationPresent(SubSection.class));
    }

    private void checkCollectionTypeItselfNotSubSectionAnnotated() {
        if (this.returnTypeInfo.isAnnotationPresent(SubSection.class)) {
            throw new IllDefinedConfigException("@SubSection can be placed on collection elements or map values, but it cannot be placed on Collection, List, Set, or Map directly");
        }
    }

    private List<TypeInfo<?>> getNonEmptyGenericParameters() {
        List<TypeInfo<?>> typeArguments = this.returnTypeInfo.arguments();
        if (typeArguments.isEmpty()) {
            String typeName = this.returnTypeInfo.rawType().getSimpleName();
            throw new IllDefinedConfigException(typeName + " must have generic parameters. Raw types cannot be used");
        }
        return typeArguments;
    }

    private <E, R extends Collection<E>> CollectionReturnType<E, ?> makeCollectionReturnType(TypeInfo<R> returnTypeInfo) {
        this.checkCollectionTypeItselfNotSubSectionAnnotated();
        List<TypeInfo<?>> typeArguments = this.getNonEmptyGenericParameters();
        TypeInfo<?> elementTypeInfo = typeArguments.get(0);
        if (elementTypeInfo.isAnnotationPresent(SubSection.class)) {
            return new SubSectionCollectionReturnType(returnTypeInfo, this.reader.createChildDefinition(elementTypeInfo));
        }
        return new SimpleCollectionReturnType(returnTypeInfo);
    }

    private <K, V> MapReturnType<K, V> makeMapReturnType(TypeInfo<Map<K, V>> returnTypeInfo) {
        this.checkCollectionTypeItselfNotSubSectionAnnotated();
        List<TypeInfo<?>> typeArguments = this.getNonEmptyGenericParameters();
        if (typeArguments.get(0).isAnnotationPresent(SubSection.class)) {
            throw new IllDefinedConfigException("@SubSection can be placed on map values, but not map keys");
        }
        TypeInfo<?> valueTypeInfo = typeArguments.get(1);
        if (valueTypeInfo.isAnnotationPresent(SubSection.class)) {
            return new SubSectionMapReturnType<K, V>(returnTypeInfo, this.reader.createChildDefinition(valueTypeInfo));
        }
        return new SimpleMapReturnType<K, V>(returnTypeInfo);
    }

    private <T> ReturnType<T> makeSimpleReturnType(TypeInfo<T> returnTypeInfo, boolean forceSubSection) {
        if (forceSubSection || returnTypeInfo.isAnnotationPresent(SubSection.class)) {
            return new SimpleSubSectionReturnType<T>(returnTypeInfo, this.reader.createChildDefinition(returnTypeInfo));
        }
        return new SimpleTypeReturnType<T>(returnTypeInfo);
    }
}

