/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.processor;

import java.util.Map;
import space.arim.dazzleconf.ConfigurationOptions;
import space.arim.dazzleconf.error.BadValueException;
import space.arim.dazzleconf.error.ImproperEntryException;
import space.arim.dazzleconf.error.InvalidConfigException;
import space.arim.dazzleconf.internal.ConfEntry;
import space.arim.dazzleconf.internal.ConfigurationDefinition;
import space.arim.dazzleconf.internal.NestedMapHelper;
import space.arim.dazzleconf.internal.processor.ProcessorBase;

public class MapProcessor<C>
extends ProcessorBase<C> {
    private final NestedMapHelper mapHelper;

    public MapProcessor(ConfigurationOptions options, ConfigurationDefinition<C> definition, Map<String, Object> sourceMap, C auxiliaryValues) {
        this(options, definition, new NestedMapHelper(sourceMap), auxiliaryValues);
    }

    private MapProcessor(ConfigurationOptions options, ConfigurationDefinition<C> definition, NestedMapHelper mapHelper, C auxiliaryValues) {
        super(options, definition, auxiliaryValues);
        this.mapHelper = mapHelper;
    }

    @Override
    <N> N createChildConfig(ConfigurationOptions options, ConfigurationDefinition<N> childDefinition, String key, Object preValue, N nestedAuxiliaryValues) throws InvalidConfigException {
        if (!(preValue instanceof Map)) {
            throw new BadValueException.Builder().key(key).message("Object " + preValue + " is not a configuration section").build();
        }
        Map childMap = (Map)preValue;
        return this.createFromProcessor(new MapProcessor<N>(options, childDefinition, childMap, nestedAuxiliaryValues));
    }

    @Override
    Object getValueFromSources(ConfEntry entry) throws ImproperEntryException {
        return this.mapHelper.get(entry.getKey());
    }
}

