/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import space.arim.dazzleconf.error.IllDefinedConfigException;

public final class MethodUtil {
    private static final boolean IS_JAVA_8;

    private MethodUtil() {
    }

    public static String getQualifiedName(Method method) {
        return method.getDeclaringClass().getName() + "#" + method.getName();
    }

    public static boolean isDefault(Method method) {
        boolean isDefault;
        int modifiers = method.getModifiers();
        boolean bl = isDefault = (modifiers & 0x409) == 1;
        assert (isDefault == method.isDefault());
        return isDefault;
    }

    public static MethodHandle createDefaultMethodHandle(Method method) {
        if (IS_JAVA_8) {
            return Java8DefaultMethodHandle.getMethodHandle(method);
        }
        Class<?> declaringClass = method.getDeclaringClass();
        try {
            return MethodHandles.privateLookupIn(declaringClass, MethodHandles.lookup()).unreflectSpecial(method, declaringClass);
        }
        catch (IllegalAccessException ex) {
            throw new IllDefinedConfigException("Unable to generate default method accessor for " + MethodUtil.getQualifiedName(method), ex);
        }
    }

    static {
        boolean isJava8 = false;
        try {
            MethodHandles.class.getDeclaredMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException nsme) {
            isJava8 = true;
        }
        IS_JAVA_8 = isJava8;
    }

    private static class Java8DefaultMethodHandle {
        private static final Constructor<MethodHandles.Lookup> lookupConstructor;

        private Java8DefaultMethodHandle() {
        }

        static MethodHandle getMethodHandle(Method method) {
            Class<?> declaringClass = method.getDeclaringClass();
            try {
                return lookupConstructor.newInstance(declaringClass).unreflectSpecial(method, declaringClass);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new IllDefinedConfigException("Unable to generate default method accessor for " + MethodUtil.getQualifiedName(method), ex);
            }
        }

        static {
            try {
                lookupConstructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                lookupConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
    }
}

