/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal.util;

import java.lang.reflect.Modifier;

public final class AccessChecking {
    private static final boolean JPMS;

    private AccessChecking() {
    }

    public static boolean isAccessible(Class<?> type) {
        return Modifier.isPublic(type.getModifiers()) && (!JPMS || AccessCheckingJPMS.isAccessible(type));
    }

    static {
        boolean jpms;
        try {
            Class.forName("java.lang.Module");
            jpms = true;
        }
        catch (ClassNotFoundException java8) {
            jpms = false;
        }
        JPMS = jpms;
    }

    static final class AccessCheckingJPMS {
        private AccessCheckingJPMS() {
        }

        static boolean isAccessible(Class<?> type) {
            return type.getModule().isExported(type.getPackageName(), AccessCheckingJPMS.class.getModule());
        }
    }
}

