/*
 * Decompiled with CFR 0.152.
 */
package space.arim.dazzleconf.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import space.arim.dazzleconf.annote.ConfComments;
import space.arim.dazzleconf.annote.ConfKey;
import space.arim.dazzleconf.annote.ConfValidator;
import space.arim.dazzleconf.error.IllDefinedConfigException;
import space.arim.dazzleconf.internal.ConfEntry;
import space.arim.dazzleconf.internal.ConfigurationDefinition;
import space.arim.dazzleconf.internal.DefinitionReader;
import space.arim.dazzleconf.internal.type.ReturnType;
import space.arim.dazzleconf.internal.type.ReturnTypeCreation;
import space.arim.dazzleconf.internal.type.SimpleSubSectionReturnType;
import space.arim.dazzleconf.internal.type.TypeInfo;
import space.arim.dazzleconf.internal.type.TypeInfoCreation;
import space.arim.dazzleconf.internal.util.ImmutableCollections;
import space.arim.dazzleconf.internal.util.MethodUtil;
import space.arim.dazzleconf.validator.ValueValidator;

class ConfEntryCreation {
    private final DefinitionReader<?> reader;
    private final Method method;
    private final TypeInfoCreation typeInfoCreation;

    ConfEntryCreation(DefinitionReader<?> reader, Method method, TypeInfoCreation typeInfoCreation) {
        this.reader = reader;
        this.method = method;
        this.typeInfoCreation = typeInfoCreation;
    }

    private String getQualifiedMethodName() {
        return MethodUtil.getQualifiedName(this.method);
    }

    ConfEntry create() {
        List<String> comments;
        if (this.method.getParameterCount() > 0) {
            throw new IllDefinedConfigException(this.getQualifiedMethodName() + " should not have parameters");
        }
        TypeInfo<?> returnTypeInfo = this.typeInfoCreation.create(this.method.getReturnType());
        if (!returnTypeInfo.isTypeAccessible()) {
            throw new IllDefinedConfigException(this.getQualifiedMethodName() + " has inaccessible return type " + returnTypeInfo.rawType());
        }
        ReturnType<?> returnType = new ReturnTypeCreation(this.reader, returnTypeInfo).create(this.method);
        if (returnType instanceof SimpleSubSectionReturnType) {
            ConfigurationDefinition configDefinition = ((SimpleSubSectionReturnType)returnType).configDefinition();
            comments = this.findComments(configDefinition::getHeader);
        } else {
            comments = this.findComments(ImmutableCollections::emptyList);
        }
        return new ConfEntry(this.method, this.findKey(), comments, returnType, this.getValidator());
    }

    private ValueValidator getValidator() {
        ConfValidator chosenValidator = this.method.getAnnotation(ConfValidator.class);
        return chosenValidator == null ? null : this.reader.instantiate(ValueValidator.class, chosenValidator.value());
    }

    private String findKey() {
        ConfKey confKey = this.method.getAnnotation(ConfKey.class);
        return confKey != null ? confKey.value() : this.method.getName();
    }

    private List<String> findComments(Supplier<List<String>> backupSupplier) {
        ConfComments commentsAnnotation = this.method.getAnnotation(ConfComments.class);
        if (commentsAnnotation != null) {
            return ImmutableCollections.listOf(commentsAnnotation.value());
        }
        return backupSupplier.get();
    }
}

