/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.util;

public class UnknownGenericException
extends RuntimeException {
    private final String genericName;
    private final Class contextType;

    public UnknownGenericException(String genericName) {
        this(null, genericName);
    }

    public UnknownGenericException(Class contextType, String genericName) {
        this(contextType, genericName, null);
    }

    UnknownGenericException(Class contextType, String genericName, Throwable cause) {
        super(String.format("Generic '%s' is not declared %s", genericName, contextType == null ? "" : "on type " + contextType.getName()), cause);
        this.contextType = contextType;
        this.genericName = genericName;
    }

    public String getGenericName() {
        return this.genericName;
    }

    public Class getContextType() {
        return this.contextType;
    }

    public UnknownGenericException rethrowWithType(Class type) {
        boolean sameType = this.contextType != null && this.contextType.equals(type);
        return sameType ? this : new UnknownGenericException(type, this.genericName, this);
    }
}

