/*
 * Decompiled with CFR 0.152.
 */
package ru.endlesscode.mimic.level;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import ru.endlesscode.mimic.level.ExpLevelConverter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0014H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0014H\u0016J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0010\u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0016J\u0010\u0010*\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0014H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\"\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR$\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u0018\u0010\u0013\u001a\u00020\u0014X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\n\"\u0004\b\u001b\u0010\fR\u0014\u0010\u001c\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006+\u00c0\u0006\u0001"}, d2={"Lru/endlesscode/mimic/level/LevelSystem;", "", "converter", "Lru/endlesscode/mimic/level/ExpLevelConverter;", "getConverter", "()Lru/endlesscode/mimic/level/ExpLevelConverter;", "<set-?>", "", "exp", "getExp", "()D", "setExp", "(D)V", "expToNextLevel", "getExpToNextLevel", "value", "fractionalExp", "getFractionalExp", "setFractionalExp", "level", "", "getLevel", "()I", "setLevel", "(I)V", "totalExp", "getTotalExp", "setTotalExp", "totalExpToNextLevel", "getTotalExpToNextLevel", "didReachLevel", "", "requiredLevel", "giveExp", "", "expAmount", "giveLevels", "lvlAmount", "hasExp", "requiredExp", "hasExpTotal", "takeExp", "takeLevels", "mimic-api"})
public interface LevelSystem {
    @NotNull
    public ExpLevelConverter getConverter();

    public int getLevel();

    public void setLevel(int var1);

    default public double getTotalExp() {
        double levelExp = this.getConverter().levelToExp(this.getLevel());
        return levelExp + this.getExp();
    }

    default public void setTotalExp(double value) {
        double allowedTotalExperience = RangesKt.coerceAtLeast((double)value, (double)0.0);
        int fullLevels = this.getConverter().expToFullLevel(allowedTotalExperience);
        double levelExp = this.getConverter().levelToExp(fullLevels);
        this.setLevel(fullLevels);
        this.setExp(allowedTotalExperience - levelExp);
    }

    default public double getFractionalExp() {
        double expToNextLevel = this.getTotalExpToNextLevel();
        double exp = RangesKt.coerceAtMost((double)this.getExp(), (double)(expToNextLevel - 1.0));
        return exp <= 0.0 ? 0.0 : exp / expToNextLevel;
    }

    default public void setFractionalExp(double value) {
        double d;
        double allowedExp = RangesKt.coerceAtLeast((double)value, (double)0.0);
        if (value < 1.0) {
            d = this.getConverter().getExpToReachNextLevel(this.getLevel()) * allowedExp;
        } else {
            this.giveLevels(1);
            d = 0.0;
        }
        this.setExp(d);
    }

    public double getExp();

    @Deprecated(message="Better to use giveExp or takeExp to change experience value.")
    public void setExp(double var1);

    default public double getTotalExpToNextLevel() {
        return this.getConverter().getExpToReachNextLevel(this.getLevel());
    }

    default public double getExpToNextLevel() {
        return this.getTotalExpToNextLevel() - this.getExp();
    }

    default public void takeLevels(int lvlAmount) {
        int currentLevel = this.getLevel();
        this.setLevel(currentLevel - RangesKt.coerceAtMost((int)lvlAmount, (int)currentLevel));
    }

    default public void giveLevels(int lvlAmount) {
        this.setLevel(this.getLevel() + lvlAmount);
    }

    default public boolean didReachLevel(int requiredLevel) {
        return RangesKt.coerceAtLeast((int)requiredLevel, (int)0) <= this.getLevel();
    }

    default public void takeExp(double expAmount) {
        double currentTotalExp = this.getTotalExp();
        this.setTotalExp(currentTotalExp - RangesKt.coerceAtMost((double)expAmount, (double)currentTotalExp));
    }

    default public void giveExp(double expAmount) {
        this.setTotalExp(this.getTotalExp() + expAmount);
    }

    default public boolean hasExp(double requiredExp) {
        return RangesKt.coerceAtLeast((double)requiredExp, (double)0.0) <= this.getExp();
    }

    default public boolean hasExpTotal(double requiredExp) {
        return RangesKt.coerceAtLeast((double)requiredExp, (double)0.0) <= this.getTotalExp();
    }
}

