/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astralibs.filemanager;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astralibs.filemanager.ResourceFileManager;
import ru.astrainteractive.astralibs.filemanager.SpigotFileManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0016R\u001a\u0010\t\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lru/astrainteractive/astralibs/filemanager/DefaultSpigotFileManager;", "Lru/astrainteractive/astralibs/filemanager/SpigotFileManager;", "plugin", "Lorg/bukkit/plugin/Plugin;", "name", "", "dataFolder", "Ljava/io/File;", "(Lorg/bukkit/plugin/Plugin;Ljava/lang/String;Ljava/io/File;)V", "configFile", "getConfigFile", "()Ljava/io/File;", "setConfigFile", "(Ljava/io/File;)V", "getDataFolder", "<set-?>", "Lorg/bukkit/configuration/file/FileConfiguration;", "fileConfiguration", "getFileConfiguration", "()Lorg/bukkit/configuration/file/FileConfiguration;", "isResourceExists", "", "()Z", "getName", "()Ljava/lang/String;", "delete", "", "loadConfigFile", "loadFileConfiguration", "loadFromResource", "reload", "save", "spigot-core"})
public final class DefaultSpigotFileManager
implements SpigotFileManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final String name;
    @NotNull
    private final File dataFolder;
    @NotNull
    private File configFile;
    @NotNull
    private FileConfiguration fileConfiguration;

    public DefaultSpigotFileManager(@NotNull Plugin plugin, @NotNull String name, @NotNull File dataFolder) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dataFolder, (String)"dataFolder");
        this.plugin = plugin;
        this.name = name;
        this.dataFolder = dataFolder;
        this.configFile = this.loadConfigFile();
        this.fileConfiguration = this.loadFileConfiguration();
    }

    public /* synthetic */ DefaultSpigotFileManager(Plugin plugin, String string, File file, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            File file2 = plugin.getDataFolder();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"plugin.dataFolder");
            file = file2;
        }
        this(plugin, string, file);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public File getDataFolder() {
        return this.dataFolder;
    }

    @NotNull
    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.configFile = file;
    }

    @Override
    @NotNull
    public FileConfiguration getFileConfiguration() {
        return this.fileConfiguration;
    }

    public boolean isResourceExists() {
        return this.plugin.getResource(this.getName()) != null;
    }

    private final File loadFromResource() {
        this.plugin.saveResource(this.getName(), true);
        return new File(this.getDataFolder(), this.getName());
    }

    private final File loadConfigFile() {
        File file = new File(this.getDataFolder(), this.getName());
        if (file.exists()) {
            return file;
        }
        if (!this.isResourceExists()) {
            throw new ResourceFileManager.Exception.ResourceNotExists(this.getName());
        }
        return this.loadFromResource();
    }

    private final FileConfiguration loadFileConfiguration() {
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.getConfigFile());
        Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration, (String)"loadConfiguration(configFile)");
        YamlConfiguration fileConfiguration = yamlConfiguration;
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((File)this.getConfigFile());
        Intrinsics.checkNotNullExpressionValue((Object)yamlConfiguration2, (String)"loadConfiguration(configFile)");
        YamlConfiguration defaultConfig = yamlConfiguration2;
        fileConfiguration.setDefaults((Configuration)defaultConfig);
        return (FileConfiguration)fileConfiguration;
    }

    @Override
    public void save() {
        this.getFileConfiguration().save(this.getConfigFile());
    }

    public void delete() {
        this.getConfigFile().delete();
        this.getFileConfiguration().load(this.getConfigFile());
    }

    @Override
    public void reload() {
        this.setConfigFile(this.loadConfigFile());
        this.fileConfiguration = this.loadFileConfiguration();
    }
}

