/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astralibs.economy;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astralibs.economy.EconomyProvider;
import ru.astrainteractive.astralibs.economy.VaultEconomyServiceProvider;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0015\u0010\u0010\u001a\u00070\f\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lru/astrainteractive/astralibs/economy/VaultEconomyProvider;", "Lru/astrainteractive/astralibs/economy/EconomyProvider;", "econ", "Lnet/milkbowl/vault/economy/Economy;", "(Lnet/milkbowl/vault/economy/Economy;)V", "addMoney", "", "uuid", "Ljava/util/UUID;", "amount", "", "player", "Lorg/bukkit/OfflinePlayer;", "getBalance", "(Ljava/util/UUID;)Ljava/lang/Double;", "hasAtLeast", "offlinePlayer", "Lorg/jetbrains/annotations/NotNull;", "takeMoney", "spigot-core"})
public final class VaultEconomyProvider
implements EconomyProvider {
    @NotNull
    private final Economy econ;

    public VaultEconomyProvider(@NotNull Economy econ) {
        Intrinsics.checkNotNullParameter((Object)econ, (String)"econ");
        this.econ = econ;
    }

    public /* synthetic */ VaultEconomyProvider(Economy economy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            economy = VaultEconomyServiceProvider.INSTANCE.provide();
        }
        this(economy);
    }

    private final OfflinePlayer offlinePlayer(UUID uuid) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getOfflinePlayer(uuid)");
        return offlinePlayer;
    }

    private final double getBalance(OfflinePlayer player) {
        return this.econ.getBalance(player);
    }

    private final boolean takeMoney(OfflinePlayer player, double amount) {
        EconomyResponse response;
        double maxBalance = this.getBalance(player);
        if (amount > maxBalance) {
            return false;
        }
        EconomyResponse economyResponse = response = this.econ.withdrawPlayer(player, amount);
        return (economyResponse != null ? economyResponse.type : null) == EconomyResponse.ResponseType.SUCCESS;
    }

    private final boolean addMoney(OfflinePlayer player, double amount) {
        EconomyResponse response;
        EconomyResponse economyResponse = response = this.econ.depositPlayer(player, amount);
        return (economyResponse != null ? economyResponse.type : null) == EconomyResponse.ResponseType.SUCCESS;
    }

    @NotNull
    public Double getBalance(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.getBalance(this.offlinePlayer(uuid));
    }

    public boolean takeMoney(@NotNull UUID uuid, double amount) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.takeMoney(this.offlinePlayer(uuid), amount);
    }

    public boolean addMoney(@NotNull UUID uuid, double amount) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.addMoney(this.offlinePlayer(uuid), amount);
    }

    public boolean hasAtLeast(@NotNull UUID uuid, double amount) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.getBalance(uuid) >= amount;
    }

    public VaultEconomyProvider() {
        this(null, 1, null);
    }
}

