/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astralibs.orm.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astralibs.orm.Database;
import ru.astrainteractive.astralibs.orm.database.Column;
import ru.astrainteractive.astralibs.orm.database.Constructable;
import ru.astrainteractive.astralibs.orm.database.Entity;
import ru.astrainteractive.astralibs.orm.exception.DatabaseException;
import ru.astrainteractive.astralibs.orm.expression.Expression;
import ru.astrainteractive.astralibs.orm.expression.SQLExpressionBuilder;
import ru.astrainteractive.astralibs.orm.query.CountQuery;
import ru.astrainteractive.astralibs.orm.query.CreateQuery;
import ru.astrainteractive.astralibs.orm.query.DeleteQuery;
import ru.astrainteractive.astralibs.orm.query.InsertQuery;
import ru.astrainteractive.astralibs.orm.query.SelectQuery;
import ru.astrainteractive.astralibs.orm.query.UpdateQuery;
import ru.astrainteractive.astralibs.orm.statement.DBStatement;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00130\n\"\u000e\b\u0001\u0010\u0013*\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\b2\u0006\u0010\u001d\u001a\u00020\u0004J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\b2\u0006\u0010\u001d\u001a\u00020\u0004J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\b2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u001fJ-\u0010#\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u001d\u0010$\u001a\u0019\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0%\u00a2\u0006\u0002\b)J\u0019\u0010*\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J=\u0010-\u001a\u00020+\"\u000e\b\u0001\u0010\u0013*\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u001d\u0010$\u001a\u0019\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0%\u00a2\u0006\u0002\b)J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\b2\u0006\u0010\u001d\u001a\u00020\u0004J\u0019\u00100\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,JQ\u00101\u001a\b\u0012\u0004\u0012\u0002H\u00130\n\"\u000e\b\u0001\u0010\u0013*\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00182\u001d\u0010$\u001a\u0019\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0%\u00a2\u0006\u0002\b)J\u0014\u00102\u001a\b\u0012\u0004\u0012\u0002030\b2\u0006\u0010\u001d\u001a\u00020\u0004J'\u00104\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0017\u00105\u001a\u0013\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020+0%\u00a2\u0006\u0002\b)J\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020\u001f0\b2\u0006\u0010\u001d\u001a\u00020\u0004J\u001e\u00108\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u001d\u001a\u00020\u00042\b\b\u0002\u0010\"\u001a\u00020\u001fJ+\u00109\u001a\u00020+\"\u000e\b\u0001\u0010\u0013*\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010:\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010;J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u001fJ1\u0010=\u001a\u0002H\u0013\"\u000e\b\u0001\u0010\u0013*\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010>\u001a\u00020?2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0018\u00a2\u0006\u0002\u0010@R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006A"}, d2={"Lru/astrainteractive/astralibs/orm/database/Table;", "T", "", "tableName", "", "(Ljava/lang/String;)V", "_columns", "", "Lru/astrainteractive/astralibs/orm/database/Column;", "columns", "", "getColumns", "()Ljava/util/List;", "id", "getId", "()Lru/astrainteractive/astralibs/orm/database/Column;", "getTableName", "()Ljava/lang/String;", "all", "K", "Lru/astrainteractive/astralibs/orm/database/Entity;", "database", "Lru/astrainteractive/astralibs/orm/Database;", "constructor", "Lru/astrainteractive/astralibs/orm/database/Constructable;", "assertConnected", "Ljava/sql/Connection;", "bigint", "", "name", "bool", "", "byteArray", "", "size", "count", "op", "Lkotlin/Function1;", "Lru/astrainteractive/astralibs/orm/expression/SQLExpressionBuilder;", "Lru/astrainteractive/astralibs/orm/expression/Expression;", "", "Lkotlin/ExtensionFunctionType;", "create", "", "(Lru/astrainteractive/astralibs/orm/Database;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "delete", "double", "", "drop", "find", "float", "", "insert", "stmt", "Lru/astrainteractive/astralibs/orm/statement/DBStatement;", "integer", "text", "update", "entity", "(Lru/astrainteractive/astralibs/orm/Database;Lru/astrainteractive/astralibs/orm/database/Entity;)V", "varchar", "wrap", "it", "Ljava/sql/ResultSet;", "(Ljava/sql/ResultSet;Lru/astrainteractive/astralibs/orm/database/Constructable;)Lru/astrainteractive/astralibs/orm/database/Entity;", "orm"})
@SourceDebugExtension(value={"SMAP\nTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Table.kt\nru/astrainteractive/astralibs/orm/database/Table\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ext.kt\nru/astrainteractive/astralibs/orm/ExtKt\n*L\n1#1,173:1\n1#2:174\n1#2:199\n1#2:215\n1864#3,3:175\n1855#3,2:178\n766#3:180\n857#3,2:181\n1864#3,3:183\n41#4,11:186\n32#4,2:197\n35#4:200\n52#4:201\n41#4,11:202\n32#4,2:213\n35#4:216\n52#4:217\n*S KotlinDebug\n*F\n+ 1 Table.kt\nru/astrainteractive/astralibs/orm/database/Table\n*L\n134#1:199\n149#1:215\n73#1:175,3\n90#1:178,2\n100#1:180\n100#1:181,2\n104#1:183,3\n134#1:186,11\n134#1:197,2\n134#1:200\n134#1:201\n149#1:202,11\n149#1:213,2\n149#1:216\n149#1:217\n*E\n"})
public abstract class Table<T> {
    @NotNull
    private final String tableName;
    @NotNull
    private final List<Column<?>> _columns;

    public Table(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this.tableName = tableName;
        this._columns = new ArrayList();
    }

    @NotNull
    public final String getTableName() {
        return this.tableName;
    }

    @NotNull
    public final List<Column<?>> getColumns() {
        return this._columns;
    }

    @NotNull
    public abstract Column<T> getId();

    @NotNull
    public final Column<Integer> integer(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Column.IntColumn intColumn = new Column.IntColumn(name);
        List<Column<?>> list = this._columns;
        Column p0 = intColumn;
        boolean bl = false;
        list.add(p0);
        return intColumn;
    }

    @NotNull
    public final Column<Long> bigint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Column.BigIntColumn bigIntColumn = new Column.BigIntColumn(name);
        List<Column<?>> list = this._columns;
        Column p0 = bigIntColumn;
        boolean bl = false;
        list.add(p0);
        return bigIntColumn;
    }

    @NotNull
    public final Column<String> text(@NotNull String name, int size) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Column.TextColumn textColumn = new Column.TextColumn(name, size);
        List<Column<?>> list = this._columns;
        Column p0 = textColumn;
        boolean bl = false;
        list.add(p0);
        return textColumn;
    }

    public static /* synthetic */ Column text$default(Table table, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: text");
        }
        if ((n2 & 2) != 0) {
            n = 65535;
        }
        return table.text(string, n);
    }

    @NotNull
    public final Column<String> varchar(@NotNull String name, int size) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Column.StringColumn stringColumn = new Column.StringColumn(name, size);
        List<Column<?>> list = this._columns;
        Column p0 = stringColumn;
        boolean bl = false;
        list.add(p0);
        return stringColumn;
    }

    @NotNull
    public final Column<Integer> bool(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Column.BoolColumn boolColumn = new Column.BoolColumn(name);
        List<Column<?>> list = this._columns;
        Column p0 = boolColumn;
        boolean bl = false;
        list.add(p0);
        return boolColumn;
    }

    @NotNull
    public final Column<Float> float(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Column.FloatColumn floatColumn = new Column.FloatColumn(name);
        List<Column<?>> list = this._columns;
        Column p0 = floatColumn;
        boolean bl = false;
        list.add(p0);
        return floatColumn;
    }

    @NotNull
    public final Column<Double> double(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Column.DoubleColumn doubleColumn = new Column.DoubleColumn(name);
        List<Column<?>> list = this._columns;
        Column p0 = doubleColumn;
        boolean bl = false;
        list.add(p0);
        return doubleColumn;
    }

    @NotNull
    public final Column<byte[]> byteArray(@NotNull String name, int size) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Column.ByteArrayColumn byteArrayColumn = new Column.ByteArrayColumn(name, size);
        List<Column<?>> list = this._columns;
        Column p0 = byteArrayColumn;
        boolean bl = false;
        list.add(p0);
        return byteArrayColumn;
    }

    private final Connection assertConnected(Database database) {
        Object object = database;
        if (object == null || (object = object.getConnection()) == null) {
            throw DatabaseException.DatabaseNotConnectedException.INSTANCE;
        }
        Object connection = object;
        if (!database.isConnected()) {
            throw DatabaseException.DatabaseNotConnectedException.INSTANCE;
        }
        return connection;
    }

    @Nullable
    public final Object create(@NotNull Database database, @NotNull Continuation<? super Unit> $completion) {
        PreparedStatement preparedStatement;
        String query = new CreateQuery(this, database.getDbSyntax()).generate();
        Connection connection = this.assertConnected(database);
        PreparedStatement it = preparedStatement = connection.prepareStatement(query);
        boolean bl = false;
        it.execute();
        it.close();
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object drop(@NotNull Database database, @NotNull Continuation<? super Unit> $completion) {
        PreparedStatement preparedStatement;
        Connection connection = this.assertConnected(database);
        PreparedStatement it = preparedStatement = connection.prepareStatement("DROP TABLE IF EXISTS " + this.tableName);
        boolean bl = false;
        it.execute();
        it.close();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public final int insert(@NotNull Database database, @NotNull Function1<? super DBStatement, Unit> stmt) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(stmt, (String)"stmt");
        Connection connection = this.assertConnected(database);
        DBStatement dBStatement = new DBStatement();
        stmt.invoke((Object)dBStatement);
        DBStatement dbstatement = dBStatement;
        String query = new InsertQuery(this, dbstatement).generate();
        PreparedStatement statement = connection.prepareStatement(query, 1);
        Iterable $this$forEachIndexed$iv = dbstatement.getValues().values();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void v;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int i = n;
            boolean bl = false;
            statement.setObject(i + 1, v);
        }
        statement.executeUpdate();
        ResultSet generatedKeys = statement.getGeneratedKeys();
        if (generatedKeys.next()) {
            int id = generatedKeys.getInt(1);
            statement.close();
            return id;
        }
        statement.close();
        throw DatabaseException.NoIdReturned.INSTANCE;
    }

    @NotNull
    public final <K extends Entity<T>> K wrap(@NotNull ResultSet it, @NotNull Constructable<K> constructor) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
        Entity entity = (Entity)constructor.getConstruct().invoke();
        Table table = entity.getTable();
        Iterable $this$forEach$iv = table._columns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Column column = (Column)element$iv;
            boolean bl = false;
            Object obj = it.getObject(column.getName());
            Intrinsics.checkNotNull((Object)column, (String)"null cannot be cast to non-null type ru.astrainteractive.astralibs.orm.database.Column<kotlin.Any?>");
            entity.set(column, obj);
        }
        return (K)entity;
    }

    /*
     * WARNING - void declaration
     */
    public final <K extends Entity<T>> void update(@NotNull Database database, @NotNull K entity) {
        Object statement;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Connection connection = this.assertConnected(database);
        Iterable $this$filter$iv = entity.getTable()._columns;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Column it = (Column)element$iv$iv;
            boolean bl = false;
            if (!(!it.getPrimaryKey())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List columns = (List)destination$iv$iv;
        String query = new UpdateQuery(this, entity).generate();
        Object statement2 = object = connection.prepareStatement(query);
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = columns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void column;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Column column2 = (Column)item$iv;
            int index = n;
            boolean bl2 = false;
            statement2.setObject(index + 1, entity.get(column));
        }
        Object it = object = (statement = object);
        boolean bl3 = false;
        it.executeUpdate();
        it.close();
    }

    public final <K extends Entity<T>> void delete(@NotNull Database database, @NotNull Function1<? super SQLExpressionBuilder, ? extends Expression<Boolean>> op) {
        PreparedStatement statement;
        PreparedStatement preparedStatement;
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(op, (String)"op");
        Connection connection = this.assertConnected(database);
        String query = new DeleteQuery(this, op).generate();
        PreparedStatement it = preparedStatement = (statement = connection.prepareStatement(query));
        boolean bl = false;
        it.execute();
        it.close();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <K extends Entity<T>> List<K> all(@NotNull Database database, @NotNull Constructable<K> constructor) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
        Connection connection = this.assertConnected(database);
        String query = new SelectQuery(this, null, null, 6, null).generate();
        PreparedStatement statement = connection.prepareStatement(query);
        ResultSet resultSet = statement.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"statement.executeQuery()");
        ResultSet $this$mapNotNull$iv = resultSet;
        boolean $i$f$mapNotNull = false;
        ResultSet resultSet2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        while ($this$forEach$iv$iv$iv.next()) {
            K it$iv$iv;
            void element$iv$iv = $this$forEach$iv$iv$iv;
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (this.wrap((ResultSet)it, constructor) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List wrapperd = (List)destination$iv$iv;
        statement.close();
        return wrapperd;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <K extends Entity<T>> List<K> find(@NotNull Database database, @NotNull Constructable<K> constructor, @NotNull Function1<? super SQLExpressionBuilder, ? extends Expression<Boolean>> op) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter(op, (String)"op");
        String query = new SelectQuery(this, null, op, 2, null).generate();
        Connection connection = this.assertConnected(database);
        PreparedStatement statement = connection.prepareStatement(query);
        ResultSet resultSet = statement.executeQuery();
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"statement.executeQuery()");
        ResultSet $this$mapNotNull$iv = resultSet;
        boolean $i$f$mapNotNull = false;
        ResultSet resultSet2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        while ($this$forEach$iv$iv$iv.next()) {
            K it$iv$iv;
            void element$iv$iv = $this$forEach$iv$iv$iv;
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (this.wrap((ResultSet)it, constructor) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List wrapped = (List)destination$iv$iv;
        statement.close();
        return wrapped;
    }

    public final int count(@NotNull Database database, @NotNull Function1<? super SQLExpressionBuilder, ? extends Expression<Boolean>> op) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(op, (String)"op");
        Connection connection = this.assertConnected(database);
        String query = new CountQuery(this, op).generate();
        PreparedStatement statement = connection.prepareStatement(query);
        ResultSet rs = statement.executeQuery();
        if (rs.next()) {
            int id = rs.getInt("total");
            statement.close();
            return id;
        }
        statement.close();
        throw DatabaseException.NoIdReturned.INSTANCE;
    }
}

