/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astralibs.orm;

import java.sql.Connection;
import java.sql.DriverManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astralibs.orm.DBConnection;
import ru.astrainteractive.astralibs.orm.DBSyntax;
import ru.astrainteractive.astralibs.orm.Database;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0013\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0011\u0010\u0016\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lru/astrainteractive/astralibs/orm/DefaultDatabase;", "Lru/astrainteractive/astralibs/orm/Database;", "dbConnection", "Lru/astrainteractive/astralibs/orm/DBConnection;", "dbSyntax", "Lru/astrainteractive/astralibs/orm/DBSyntax;", "(Lru/astrainteractive/astralibs/orm/DBConnection;Lru/astrainteractive/astralibs/orm/DBSyntax;)V", "<set-?>", "Ljava/sql/Connection;", "connection", "getConnection", "()Ljava/sql/Connection;", "getDbConnection", "()Lru/astrainteractive/astralibs/orm/DBConnection;", "getDbSyntax", "()Lru/astrainteractive/astralibs/orm/DBSyntax;", "isConnected", "", "()Z", "closeConnection", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "openConnection", "orm"})
public final class DefaultDatabase
implements Database {
    @NotNull
    private final DBConnection dbConnection;
    @NotNull
    private final DBSyntax dbSyntax;
    @Nullable
    private Connection connection;

    public DefaultDatabase(@NotNull DBConnection dbConnection, @NotNull DBSyntax dbSyntax) {
        Intrinsics.checkNotNullParameter((Object)dbConnection, (String)"dbConnection");
        Intrinsics.checkNotNullParameter((Object)dbSyntax, (String)"dbSyntax");
        this.dbConnection = dbConnection;
        this.dbSyntax = dbSyntax;
    }

    @Override
    @NotNull
    public DBConnection getDbConnection() {
        return this.dbConnection;
    }

    @Override
    @NotNull
    public DBSyntax getDbSyntax() {
        return this.dbSyntax;
    }

    @Override
    @Nullable
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isConnected() {
        Connection connection = this.getConnection();
        return connection != null ? !connection.isClosed() : false;
    }

    @Override
    @Nullable
    public Object openConnection(@NotNull Continuation<? super Unit> $completion) {
        Connection connection;
        Class.forName(this.getDbConnection().getDriver());
        DBConnection dBConnection = this.getDbConnection();
        if (dBConnection instanceof DBConnection.MySQL) {
            connection = DriverManager.getConnection(this.getDbConnection().getUrl(), ((DBConnection.MySQL)this.getDbConnection()).getUsername(), ((DBConnection.MySQL)this.getDbConnection()).getPassword());
        } else if (dBConnection instanceof DBConnection.SQLite) {
            connection = DriverManager.getConnection(this.getDbConnection().getUrl());
        } else if (dBConnection instanceof DBConnection.InMemory) {
            connection = DriverManager.getConnection(this.getDbConnection().getUrl());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.connection = connection;
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object closeConnection(@NotNull Continuation<? super Unit> $completion) {
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.close();
        }
        this.connection = null;
        return Unit.INSTANCE;
    }
}

