/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astralibs.orm;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astralibs.orm.DBConnection;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lru/astrainteractive/astralibs/orm/DBConnection;", "", "driver", "", "(Ljava/lang/String;)V", "getDriver", "()Ljava/lang/String;", "url", "getUrl", "InMemory", "MySQL", "SQLite", "Lru/astrainteractive/astralibs/orm/DBConnection$InMemory;", "Lru/astrainteractive/astralibs/orm/DBConnection$MySQL;", "Lru/astrainteractive/astralibs/orm/DBConnection$SQLite;", "orm"})
public abstract class DBConnection {
    @NotNull
    private final String driver;

    private DBConnection(String driver) {
        this.driver = driver;
    }

    @NotNull
    public final String getDriver() {
        return this.driver;
    }

    @NotNull
    public abstract String getUrl();

    public /* synthetic */ DBConnection(String driver, DefaultConstructorMarker $constructor_marker) {
        this(driver);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lru/astrainteractive/astralibs/orm/DBConnection$InMemory;", "Lru/astrainteractive/astralibs/orm/DBConnection;", "dbName", "", "(Ljava/lang/String;)V", "getDbName", "()Ljava/lang/String;", "url", "getUrl", "orm"})
    public static final class InMemory
    extends DBConnection {
        @NotNull
        private final String dbName;
        @NotNull
        private final String url;

        public InMemory(@NotNull String dbName) {
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            super("org.sqlite.JDBC", null);
            this.dbName = dbName;
            this.url = "jdbc:sqlite:file:" + this.dbName + "?mode=memory&cache=shared";
        }

        @NotNull
        public final String getDbName() {
            return this.dbName;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.url;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\n\"\u00020\u0003\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\n\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u0015"}, d2={"Lru/astrainteractive/astralibs/orm/DBConnection$MySQL;", "Lru/astrainteractive/astralibs/orm/DBConnection;", "database", "", "ip", "port", "", "username", "password", "sessionVariables", "", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "getDatabase", "()Ljava/lang/String;", "getPassword", "getSessionVariables", "()[Ljava/lang/String;", "[Ljava/lang/String;", "url", "getUrl", "getUsername", "orm"})
    public static final class MySQL
    extends DBConnection {
        @NotNull
        private final String database;
        @NotNull
        private final String ip;
        private final int port;
        @NotNull
        private final String username;
        @NotNull
        private final String password;
        @NotNull
        private final String[] sessionVariables;

        public MySQL(@NotNull String database, @NotNull String ip, int port, @NotNull String username, @NotNull String password, String ... sessionVariables) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter((Object)sessionVariables, (String)"sessionVariables");
            super("com.mysql.cj.jdbc.Driver", null);
            this.database = database;
            this.ip = ip;
            this.port = port;
            this.username = username;
            this.password = password;
            this.sessionVariables = sessionVariables;
        }

        @NotNull
        public final String getDatabase() {
            return this.database;
        }

        @NotNull
        public final String getUsername() {
            return this.username;
        }

        @NotNull
        public final String getPassword() {
            return this.password;
        }

        @NotNull
        public final String[] getSessionVariables() {
            return this.sessionVariables;
        }

        @Override
        @NotNull
        public String getUrl() {
            String sv2 = this.sessionVariables.length == 0 ? "" : ArraysKt.joinToString$default((Object[])this.sessionVariables, (CharSequence)"&", (CharSequence)"?sessionVariables=", null, (int)0, null, (Function1)url.sv.1.INSTANCE, (int)28, null);
            return "jdbc:mysql://" + this.ip + ":" + this.port + "/" + this.database + sv2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lru/astrainteractive/astralibs/orm/DBConnection$SQLite;", "Lru/astrainteractive/astralibs/orm/DBConnection;", "dbName", "", "(Ljava/lang/String;)V", "getDbName", "()Ljava/lang/String;", "url", "getUrl", "orm"})
    public static final class SQLite
    extends DBConnection {
        @NotNull
        private final String dbName;

        public SQLite(@NotNull String dbName) {
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            super("org.sqlite.JDBC", null);
            this.dbName = dbName;
        }

        @NotNull
        public final String getDbName() {
            return this.dbName;
        }

        @Override
        @NotNull
        public String getUrl() {
            return "jdbc:sqlite:" + this.dbName;
        }
    }
}

