/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astralibs.logging;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astralibs.logging.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J \u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lru/astrainteractive/astralibs/logging/JUtilLogger;", "Lru/astrainteractive/astralibs/logging/Logger;", "tag", "", "folder", "Ljava/io/File;", "logger", "Ljava/util/logging/Logger;", "(Ljava/lang/String;Ljava/io/File;Ljava/util/logging/Logger;)V", "getFolder", "()Ljava/io/File;", "getTag", "()Ljava/lang/String;", "error", "", "msg", "logInFile", "", "info", "warning", "ktx-core"})
public final class JUtilLogger
implements Logger {
    @NotNull
    private final String tag;
    @NotNull
    private final File folder;
    @NotNull
    private final java.util.logging.Logger logger;

    public JUtilLogger(@NotNull String tag, @NotNull File folder, @NotNull java.util.logging.Logger logger) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.tag = tag;
        this.folder = folder;
        this.logger = logger;
    }

    public /* synthetic */ JUtilLogger(String string, File file, java.util.logging.Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            java.util.logging.Logger logger2 = java.util.logging.Logger.getGlobal();
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getGlobal()");
            logger = logger2;
        }
        this(string, file, logger);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @NotNull
    public File getFolder() {
        return this.folder;
    }

    @Override
    public void warning(@NotNull String tag, @NotNull String msg, boolean logInFile) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logger.warning("[" + tag + "]: " + msg);
        if (logInFile) {
            this.logInFile(tag, msg);
        }
    }

    @Override
    public void error(@NotNull String tag, @NotNull String msg, boolean logInFile) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logger.severe("[" + tag + "]: " + msg);
        if (logInFile) {
            this.logInFile(tag, msg);
        }
    }

    @Override
    public void info(@NotNull String tag, @NotNull String msg, boolean logInFile) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logger.info("[" + tag + "]: " + msg);
        if (logInFile) {
            this.logInFile(tag, msg);
        }
    }

    private final void logInFile(String tag, String msg) {
        String data = Logger.Companion.getDate();
        String time = Logger.Companion.getTime();
        File file = new File(this.getFolder(), data + ".log");
        if (!this.getFolder().exists()) {
            this.getFolder().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        FilesKt.appendText$default((File)file, (String)("[" + time + "] [" + tag + "]: " + msg + "\n"), null, (int)2, null);
    }
}

