/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astralibs.filemanager.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astralibs.filemanager.ResourceFileManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0002J\b\u0010\u0017\u001a\u00020\u0005H\u0002R\u0014\u0010\t\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lru/astrainteractive/astralibs/filemanager/impl/JVMResourceFileManager;", "Lru/astrainteractive/astralibs/filemanager/ResourceFileManager;", "name", "", "dataFolder", "Ljava/io/File;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/io/File;Ljava/lang/Class;)V", "configFile", "getConfigFile", "()Ljava/io/File;", "getDataFolder", "isResourceExists", "", "()Z", "getName", "()Ljava/lang/String;", "resource", "Ljava/net/URL;", "delete", "", "loadConfigFile", "loadFromResource", "ktx-core"})
@SourceDebugExtension(value={"SMAP\nJVMResourceFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JVMResourceFileManager.kt\nru/astrainteractive/astralibs/filemanager/impl/JVMResourceFileManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class JVMResourceFileManager
implements ResourceFileManager {
    @NotNull
    private final String name;
    @NotNull
    private final File dataFolder;
    @Nullable
    private final URL resource;
    private final boolean isResourceExists;
    @NotNull
    private final File configFile;

    public JVMResourceFileManager(@NotNull String name, @NotNull File dataFolder, @NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dataFolder, (String)"dataFolder");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        this.name = name;
        this.dataFolder = dataFolder;
        this.resource = clazz.getResource("/" + this.getName());
        this.isResourceExists = this.resource != null;
        this.configFile = this.loadConfigFile();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public boolean isResourceExists() {
        return this.isResourceExists;
    }

    @Override
    @NotNull
    public File getConfigFile() {
        return this.configFile;
    }

    private final File loadFromResource() {
        URLConnection connection;
        URL uRL = this.resource;
        if (uRL == null) {
            throw new ResourceFileManager.Exception.ResourceNotExists(this.getName());
        }
        URL resource = uRL;
        URLConnection uRLConnection = connection = resource.openConnection();
        if (uRLConnection != null) {
            uRLConnection.setUseCaches(false);
        }
        URLConnection uRLConnection2 = connection;
        InputStream inputStream = uRLConnection2 != null ? uRLConnection2.getInputStream() : null;
        if (inputStream == null) {
            throw new ResourceFileManager.Exception.ResourceNotExists(this.getName());
        }
        InputStream istream = inputStream;
        File file = new File(this.getDataFolder(), this.getName());
        if (file.exists()) {
            return file;
        }
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        int len = 0;
        while (true) {
            int n;
            int it = n = istream.read(buf);
            boolean bl = false;
            len = it;
            if (n <= 0) break;
            out.write(buf, 0, len);
        }
        out.close();
        istream.close();
        return file;
    }

    private final File loadConfigFile() {
        File file = new File(this.getDataFolder(), this.getName());
        if (file.exists()) {
            return file;
        }
        return this.loadFromResource();
    }

    @Override
    public void delete() {
        if (this.getConfigFile().exists()) {
            this.getConfigFile().delete();
        }
    }
}

