/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.jetty;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.AbstractWebServer;
import ro.pippo.core.PippoFilter;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.PippoServletContextListener;
import ro.pippo.jetty.JettySettings;

public class JettyServer
extends AbstractWebServer<JettySettings> {
    private static final Logger log = LoggerFactory.getLogger(JettyServer.class);
    private Server server;

    public void start() {
        this.server = this.createServer();
        ServerConnector serverConnector = this.createServerConnector(this.server);
        serverConnector.setIdleTimeout(TimeUnit.HOURS.toMillis(1L));
        serverConnector.setSoLingerTime(-1);
        serverConnector.setHost(((JettySettings)this.getSettings()).getHost());
        serverConnector.setPort(((JettySettings)this.getSettings()).getPort());
        ServerConnector[] connectors = new ServerConnector[]{serverConnector};
        this.server.setConnectors((Connector[])connectors);
        ServletContextHandler pippoHandler = this.createPippoHandler();
        this.server.setHandler((Handler)pippoHandler);
        String version = this.server.getClass().getPackage().getImplementationVersion();
        log.info("Starting Jetty Server {} on port {}", (Object)version, (Object)((JettySettings)this.getSettings()).getPort());
        try {
            this.server.start();
        }
        catch (Exception e) {
            log.error("Unable to launch Jetty", (Throwable)e);
            throw new PippoRuntimeException((Throwable)e);
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new PippoRuntimeException((Throwable)e, "Interrupted while waiting for Jetty Server to stop.", new Object[0]);
            }
            catch (Exception e) {
                throw new PippoRuntimeException((Throwable)e, "Cannot stop Jetty Server", new Object[0]);
            }
        }
    }

    protected JettySettings createDefaultSettings() {
        return new JettySettings(this.getApplication().getPippoSettings());
    }

    protected Server createServer() {
        if (((JettySettings)this.getSettings()).getMaxThreads() > 0) {
            int idleTimeout;
            int maxThreads = ((JettySettings)this.getSettings()).getMaxThreads();
            int minThreads = ((JettySettings)this.getSettings()).getMinThreads();
            if (minThreads == 0) {
                minThreads = 8;
            }
            if ((idleTimeout = ((JettySettings)this.getSettings()).getIdleTimeout()) == 0) {
                idleTimeout = 30000;
            }
            return new Server((ThreadPool)new QueuedThreadPool(maxThreads, minThreads, idleTimeout));
        }
        return new Server();
    }

    private String asJettyFriendlyPath(String path, String name) {
        try {
            new URL(path);
            log.debug("Defer interpretation of {} URL '{}' to Jetty", (Object)name, (Object)path);
            return path;
        }
        catch (MalformedURLException e) {
            if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                log.debug("Located {} '{}' on file system", (Object)name, (Object)path);
                return path;
            }
            URL url = JettyServer.class.getResource(path);
            if (url != null) {
                log.debug("Located {} '{}' on Classpath", (Object)name, (Object)path);
                return url.toExternalForm();
            }
            throw new IllegalArgumentException(String.format("%s '%s' not found", name, path));
        }
    }

    protected ServerConnector createServerConnector(Server server) {
        String truststoreFile;
        String keyStoreFile = ((JettySettings)this.getSettings()).getKeystoreFile();
        if (keyStoreFile == null) {
            return new ServerConnector(server);
        }
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(this.asJettyFriendlyPath(keyStoreFile, "Keystore file"));
        if (((JettySettings)this.getSettings()).getKeystorePassword() != null) {
            sslContextFactory.setKeyStorePassword(((JettySettings)this.getSettings()).getKeystorePassword());
        }
        if ((truststoreFile = ((JettySettings)this.getSettings()).getTruststoreFile()) != null) {
            sslContextFactory.setTrustStorePath(this.asJettyFriendlyPath(truststoreFile, "Truststore file"));
        }
        if (((JettySettings)this.getSettings()).getTruststorePassword() != null) {
            sslContextFactory.setTrustStorePassword(((JettySettings)this.getSettings()).getTruststorePassword());
        }
        return new ServerConnector(server, (SslContextFactory)sslContextFactory);
    }

    protected ServletContextHandler createPippoHandler() {
        MultipartConfigElement multipartConfig = this.createMultipartConfigElement();
        PippoHandler handler = new PippoHandler(1, multipartConfig);
        handler.setContextPath(((JettySettings)this.getSettings()).getContextPath());
        handler.setAttribute("PIPPO_APPLICATION", this.getApplication());
        this.addPippoFilter(handler);
        handler.addEventListener((EventListener)new PippoServletContextListener());
        this.listeners.forEach(listener -> {
            try {
                handler.addEventListener((EventListener)listener.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new PippoRuntimeException((Throwable)e);
            }
        });
        return handler;
    }

    protected PippoFilter createPippoFilter() {
        try {
            Class.forName("org.eclipse.jetty.websocket.server.WebSocketServerFactory");
        }
        catch (ClassNotFoundException e) {
            return super.createPippoFilter();
        }
        try {
            Class<?> pippoFilterClass = Class.forName("ro.pippo.jetty.websocket.JettyWebSocketFilter");
            return (PippoFilter)pippoFilterClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new PippoRuntimeException((Throwable)e);
        }
    }

    private void addPippoFilter(ServletContextHandler handler) {
        if (this.pippoFilterPath == null) {
            this.pippoFilterPath = "/*";
        }
        EnumSet<DispatcherType> dispatches = EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR);
        FilterHolder pippoFilterHolder = new FilterHolder((Filter)this.getPippoFilter());
        handler.addFilter(pippoFilterHolder, this.pippoFilterPath, dispatches);
        log.debug("Using pippo filter for path '{}'", (Object)this.pippoFilterPath);
    }

    private static class PippoHandler
    extends ServletContextHandler {
        private MultipartConfigElement multipartConfig;

        private PippoHandler(int options, MultipartConfigElement multipartConfig) {
            super(options);
            this.multipartConfig = multipartConfig;
        }

        public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (this.isMultipartRequest(request)) {
                baseRequest.setAttribute("org.eclipse.jetty.multipartConfig", (Object)this.multipartConfig);
            }
            super.doHandle(target, baseRequest, request, response);
        }

        private boolean isMultipartRequest(HttpServletRequest request) {
            return "POST".equalsIgnoreCase(request.getMethod()) && request.getContentType() != null && request.getContentType().toLowerCase().startsWith("multipart/form-data");
        }
    }
}

