/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import ro.pippo.core.Application;
import ro.pippo.core.ContentTypeEngine;

public class GsonEngine
implements ContentTypeEngine {
    private Gson gson;

    public void init(Application application) {
        this.gson = new GsonBuilder().registerTypeAdapter(java.util.Date.class, (Object)new ISO8601DateTimeTypeAdapter()).registerTypeAdapter(Time.class, (Object)new ISO8601TimeTypeAdapter()).registerTypeAdapter(Date.class, (Object)new ISO8601DateTypeAdapter()).create();
    }

    public String getContentType() {
        return "application/json";
    }

    public String toString(Object object) {
        return this.gson.toJson(object);
    }

    public <T> T fromString(String content, Class<T> classOfT) {
        return (T)this.gson.fromJson(content, classOfT);
    }

    public static class ISO8601DateTimeTypeAdapter
    implements JsonSerializer<java.util.Date>,
    JsonDeserializer<java.util.Date> {
        private final DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized JsonElement serialize(java.util.Date date, Type type, JsonSerializationContext jsonSerializationContext) {
            DateFormat dateFormat = this.dateTimeFormat;
            synchronized (dateFormat) {
                String dateFormatAsString = this.dateTimeFormat.format(date);
                return new JsonPrimitive(dateFormatAsString);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized java.util.Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            try {
                DateFormat dateFormat = this.dateTimeFormat;
                synchronized (dateFormat) {
                    java.util.Date date = this.dateTimeFormat.parse(jsonElement.getAsString());
                    return new java.util.Date(date.getTime() / 1000L * 1000L);
                }
            }
            catch (ParseException e) {
                throw new JsonSyntaxException(jsonElement.getAsString(), (Throwable)e);
            }
        }
    }

    public static class ISO8601TimeTypeAdapter
    implements JsonSerializer<Time>,
    JsonDeserializer<Time> {
        private final DateFormat timeFormat = new SimpleDateFormat("HH:mm:ssZ", Locale.US);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized JsonElement serialize(Time time, Type type, JsonSerializationContext jsonSerializationContext) {
            DateFormat dateFormat = this.timeFormat;
            synchronized (dateFormat) {
                String timeFormatAsString = this.timeFormat.format(time);
                return new JsonPrimitive(timeFormatAsString);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Time deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            try {
                DateFormat dateFormat = this.timeFormat;
                synchronized (dateFormat) {
                    java.util.Date date = this.timeFormat.parse(jsonElement.getAsString());
                    return new Time(date.getTime() / 1000L * 1000L);
                }
            }
            catch (ParseException e) {
                throw new JsonSyntaxException(jsonElement.getAsString(), (Throwable)e);
            }
        }
    }

    public static class ISO8601DateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                String dateFormatAsString = this.dateFormat.format(date);
                return new JsonPrimitive(dateFormatAsString);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            try {
                DateFormat dateFormat = this.dateFormat;
                synchronized (dateFormat) {
                    java.util.Date date = this.dateFormat.parse(jsonElement.getAsString());
                    return new Date(date.getTime() / 1000L * 1000L);
                }
            }
            catch (ParseException e) {
                throw new JsonSyntaxException(jsonElement.getAsString(), (Throwable)e);
            }
        }
    }
}

