/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.websocket;

import java.util.HashMap;
import java.util.Map;
import ro.pippo.core.DefaultUriMatcher;
import ro.pippo.core.UriMatcher;
import ro.pippo.core.websocket.WebSocketHandler;

public class WebSocketRouter {
    private Map<String, WebSocketHandler> handlers = new HashMap<String, WebSocketHandler>();
    private UriMatcher uriMatcher = new DefaultUriMatcher();

    public WebSocketMatch match(String requestUri) {
        for (String uriPattern : this.handlers.keySet()) {
            Map<String, String> pathParameters = this.uriMatcher.match(requestUri, uriPattern);
            if (pathParameters == null) continue;
            return new WebSocketMatch(uriPattern, this.handlers.get(uriPattern), pathParameters);
        }
        return null;
    }

    public void addRoute(String uriPattern, WebSocketHandler handler) {
        this.handlers.put(uriPattern, handler);
        this.uriMatcher.addUriPattern(uriPattern);
    }

    public static class WebSocketMatch {
        private final String uriPattern;
        private final WebSocketHandler handler;
        private final Map<String, String> pathParameters;

        public WebSocketMatch(String uriPattern, WebSocketHandler handler, Map<String, String> pathParameters) {
            this.uriPattern = uriPattern;
            this.handler = handler;
            this.pathParameters = pathParameters;
        }

        public String getUriPattern() {
            return this.uriPattern;
        }

        public WebSocketHandler getHandler() {
            return this.handler;
        }

        public Map<String, String> getPathParameters() {
            return this.pathParameters;
        }
    }
}

