/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.websocket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletException;
import ro.pippo.core.PippoFilter;
import ro.pippo.core.Request;
import ro.pippo.core.Response;
import ro.pippo.core.util.StringUtils;
import ro.pippo.core.websocket.WebSocketRouter;

public abstract class AbstractWebSocketFilter
extends PippoFilter {
    @Override
    protected void processRequest(Request request, Response response) throws IOException, ServletException {
        if (!this.acceptWebSocket(request, response)) {
            super.processRequest(request, response);
        }
    }

    protected boolean acceptWebSocket(Request request, Response response) throws IOException, ServletException {
        if (!this.headerContainsToken(request, "Upgrade", "websocket")) {
            return false;
        }
        if (!this.headerContainsToken(request, "Connection", "upgrade")) {
            response.badRequest().commit();
            return false;
        }
        if (!this.headerContainsToken(request, "Sec-websocket-version", "13")) {
            response.badRequest().header("Sec-WebSocket-Version", "13");
            return false;
        }
        String key = request.getHeader("Sec-WebSocket-Key");
        if (key == null) {
            response.badRequest().commit();
            return false;
        }
        String origin = request.getHeader("Origin");
        if (!this.verifyOrigin(origin)) {
            response.forbidden().commit();
            return false;
        }
        String subProtocol = null;
        List<String> subProtocols = this.getTokensFromHeader(request, "Sec-WebSocket-Protocol-Client");
        if (!subProtocols.isEmpty()) {
            subProtocol = this.selectSubProtocol(subProtocols);
        }
        if (subProtocol != null) {
            response.header("Sec-WebSocket-Protocol", subProtocol);
        }
        return true;
    }

    private boolean headerContainsToken(Request request, String headerName, String target) {
        Enumeration<String> headers = request.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = headers.nextElement();
            for (String token : tokens = header.split(",")) {
                if (!target.equalsIgnoreCase(token.trim())) continue;
                return true;
            }
        }
        return false;
    }

    protected List<String> getTokensFromHeader(Request request, String headerName) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<String> headers = request.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = headers.nextElement();
            for (String token : tokens = header.split(",")) {
                result.add(token.trim());
            }
        }
        return result;
    }

    protected boolean verifyOrigin(String origin) {
        return true;
    }

    protected String selectSubProtocol(List<String> subProtocols) {
        return null;
    }

    protected WebSocketRouter.WebSocketMatch findWebSocketRoute(String requestUri) {
        String path;
        String applicationPath = this.getApplication().getRouter().getContextPath();
        String string = path = applicationPath.isEmpty() ? requestUri : requestUri.substring(applicationPath.length());
        if (StringUtils.isNullOrEmpty(path)) {
            path = "/";
        }
        return this.getApplication().getWebSocketRouter().match(path);
    }
}

