/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class IoUtils {
    private IoUtils() {
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int count;
        byte[] buffer = new byte[2048];
        long total = 0L;
        while ((count = input.read(buffer)) != -1) {
            output.write(buffer, 0, count);
            total += (long)count;
        }
        return total;
    }

    public static String toString(InputStream input) throws IOException {
        StringWriter writer = new StringWriter();
        IoUtils.copy(input, (Writer)writer);
        return writer.toString();
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        int count;
        char[] buffer = new char[2048];
        long total = 0L;
        while ((count = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, count);
            total += (long)count;
        }
        return total;
    }

    public static long copy(InputStream input, Writer writer) throws IOException {
        return IoUtils.copy(new InputStreamReader(input, StandardCharsets.UTF_8), writer);
    }

    public static long copy(InputStream input, File file) throws IOException {
        try (FileOutputStream output = new FileOutputStream(file);){
            long l = IoUtils.copy(input, output);
            return l;
        }
    }

    public static void copy(String string, File file) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(string);
        }
    }

    public static byte[] getBytes(InputStream input) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((count = input.read(buffer, 0, buffer.length)) != -1) {
            output.write(buffer, 0, count);
        }
        return output.toByteArray();
    }

    public static String getResourceAsString(String resource) throws IOException {
        return IoUtils.getResourceAsString(IoUtils.class, resource);
    }

    public static String getResourceAsString(Class<?> clazz, String resource) throws IOException {
        try (InputStream inputStream = clazz.getResourceAsStream(resource);){
            String string = IoUtils.toString(inputStream);
            return string;
        }
    }

    public static IOException close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }
}

