/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.pippo.core.route.Route;
import ro.pippo.core.route.Routing;

public class RouteGroup
implements Routing {
    private String uriPattern;
    private List<Route> routes;
    private RouteGroup parent;
    private List<RouteGroup> children;
    private String name;
    private Map<String, Object> attributes;

    public RouteGroup(String uriPattern) {
        this(null, uriPattern);
    }

    public RouteGroup(RouteGroup parent, String uriPattern) {
        this.uriPattern = uriPattern;
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
        this.routes = new ArrayList<Route>();
        this.children = new ArrayList<RouteGroup>();
        this.attributes = new HashMap<String, Object>();
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public RouteGroup getParent() {
        return this.parent;
    }

    public List<RouteGroup> getChildren() {
        return this.children;
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    @Override
    public void addRoute(Route route) {
        this.routes.add(route);
    }

    @Override
    public void addRouteGroup(RouteGroup routeGroup) {
        routeGroup.parent = this;
        this.children.add(routeGroup);
    }

    public String getName() {
        return this.name;
    }

    public RouteGroup named(String name) {
        this.name = name;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RouteGroup bind(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public RouteGroup bindAll(Map<String, Object> attributes) {
        this.attributes.putAll(attributes);
        return this;
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }
}

