/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteHandler;

public abstract class ResourceHandler
implements RouteHandler {
    private static final Logger log = LoggerFactory.getLogger(ResourceHandler.class);
    public static final String PATH_PARAMETER = "path";
    private final String uriPattern;
    private boolean versioned = true;

    public ResourceHandler(String urlPath) {
        String normalizedPath = this.getNormalizedPath(urlPath);
        this.uriPattern = normalizedPath.length() > 0 ? String.format("/%s/{%s: .+}", this.getNormalizedPath(urlPath), PATH_PARAMETER) : String.format("/{%s: .+}", PATH_PARAMETER);
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public final void handle(RouteContext routeContext) {
        String resourcePath = this.getResourcePath(routeContext);
        log.trace("Request resource '{}'", (Object)resourcePath);
        if (this.versioned) {
            resourcePath = this.removeVersion(resourcePath);
        }
        this.handleResource(resourcePath, routeContext);
        routeContext.next();
    }

    public abstract void handleResource(String var1, RouteContext var2);

    public abstract String injectVersion(String var1);

    public abstract String removeVersion(String var1);

    public boolean isVersioned() {
        return this.versioned;
    }

    public ResourceHandler setVersioned(boolean versioned) {
        this.versioned = versioned;
        return this;
    }

    protected String getResourcePath(RouteContext routeContext) {
        return this.getNormalizedPath(routeContext.getParameter(PATH_PARAMETER).toString());
    }

    protected String getNormalizedPath(String path) {
        if (path.length() > 0 && '/' == path.charAt(0)) {
            path = path.substring(1);
        }
        if (path.length() > 0 && '/' == path.charAt(path.length() - 1)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

