/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.route;

import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Application;
import ro.pippo.core.Messages;
import ro.pippo.core.ParameterValue;
import ro.pippo.core.PippoSettings;
import ro.pippo.core.Request;
import ro.pippo.core.Response;
import ro.pippo.core.Session;
import ro.pippo.core.route.Route;
import ro.pippo.core.route.RouteContext;
import ro.pippo.core.route.RouteMatch;
import ro.pippo.core.util.StringUtils;

public class DefaultRouteContext
implements RouteContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultRouteContext.class);
    protected final Application application;
    protected final Request request;
    protected final Response response;
    protected final Iterator<RouteMatch> iterator;
    private Route route;

    public DefaultRouteContext(Application application, Request request, Response response, List<RouteMatch> routeMatches) {
        this.application = application;
        this.request = request;
        this.response = response;
        this.iterator = routeMatches.iterator();
    }

    public Application getApplication() {
        return this.application;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public boolean hasSession() {
        return this.request.getSession(false) != null;
    }

    @Override
    public Session getSession() {
        return this.request.getSession();
    }

    @Override
    public void recreateSession() {
        this.request.recreateSession();
    }

    @Override
    public void resetSession() {
        this.request.resetSession();
    }

    @Override
    public void touchSession() {
        this.request.getSession().touch();
    }

    @Override
    public void invalidateSession() {
        this.request.getSession().invalidate();
    }

    @Override
    public <T> T setSession(String name, T value) {
        this.getSession().put(name, value);
        return value;
    }

    @Override
    public <T> T getSession(String name) {
        return this.hasSession() ? (T)this.request.getSession().get(name) : null;
    }

    @Override
    public <T> T removeSession(String name) {
        return this.hasSession() ? (T)this.request.getSession().remove(name) : null;
    }

    @Override
    public <T> T setLocal(String name, T value) {
        this.response.getLocals().put(name, value);
        return value;
    }

    @Override
    public void setLocals(Map<String, Object> locals) {
        this.response.getLocals().putAll(locals);
    }

    @Override
    public <T> T getLocal(String name) {
        return (T)this.response.getLocals().get(name);
    }

    @Override
    public <T> T removeLocal(String name) {
        return (T)this.response.getLocals().remove(name);
    }

    @Override
    public ParameterValue getParameter(String name) {
        return this.request.getParameter(name);
    }

    @Override
    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public <T> T setHeader(String name, T value) {
        this.response.header(name, value.toString());
        return value;
    }

    @Override
    public Date setHeader(String name, Date date) {
        this.response.header(name, date);
        return date;
    }

    @Override
    public void flashError(String message, Object ... args) {
        this.request.getSession().getFlash().error(message, args);
    }

    @Override
    public void flashWarning(String message, Object ... args) {
        this.request.getSession().getFlash().warning(message, args);
    }

    @Override
    public void flashInfo(String message, Object ... args) {
        this.request.getSession().getFlash().info(message, args);
    }

    @Override
    public void flashSuccess(String message, Object ... args) {
        this.request.getSession().getFlash().success(message, args);
    }

    @Override
    public <T> T createEntityFromParameters(Class<T> classOfT) {
        return this.request.createEntityFromParameters(classOfT);
    }

    @Override
    public <T> T createEntityFromBody(Class<T> classOfT) {
        return this.request.createEntityFromBody(classOfT);
    }

    @Override
    public String getRequestUri() {
        return this.request.getApplicationUri();
    }

    @Override
    public String getRequestMethod() {
        return this.request.getMethod();
    }

    @Override
    public boolean isRequestMethod(String method) {
        return this.request.getMethod().equalsIgnoreCase(method);
    }

    @Override
    public void render(String templateName) {
        this.response.render(templateName);
    }

    @Override
    public void render(String templateName, Map<String, Object> model) {
        this.response.render(templateName, model);
    }

    @Override
    public String renderToString(String templateName) {
        return this.response.renderToString(templateName);
    }

    @Override
    public String renderToString(String templateName, Map<String, Object> model) {
        return this.response.renderToString(templateName, model);
    }

    @Override
    public void send(CharSequence content) {
        this.response.send(content);
    }

    @Override
    public void send(File file) {
        this.response.file(file);
    }

    @Override
    public void send(Object object) {
        this.response.send(object);
    }

    @Override
    public void redirect(String path) {
        this.response.redirectToApplicationPath(path);
    }

    @Override
    public void redirect(String nameOrUriPattern, Map<String, Object> parameters) {
        String uri = this.uriFor(nameOrUriPattern, parameters);
        String applicationPath = this.application.getRouter().getApplicationPath();
        if (!applicationPath.isEmpty()) {
            uri = StringUtils.removeStart(uri.substring(applicationPath.length()), "/");
        }
        this.redirect(uri);
    }

    @Override
    public void next() {
        if (this.iterator.hasNext()) {
            RouteMatch routeMatch = this.iterator.next();
            Route route = routeMatch.getRoute();
            log.trace("Found {}", (Object)route);
            Map<String, String> pathParameters = routeMatch.getPathParameters();
            if (pathParameters != null) {
                this.request.internalSetPathParameters(pathParameters);
                log.trace("Added path parameters to request");
            }
            this.iterator.remove();
            this.handleRoute(route);
        }
    }

    @Override
    public void runFinallyRoutes() {
        while (this.iterator.hasNext()) {
            Route route = this.iterator.next().getRoute();
            if (route.isRunAsFinally()) {
                try {
                    this.handleRoute(route);
                }
                catch (Exception e) {
                    log.error("Unexpected error in Finally Route", (Throwable)e);
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            if (StringUtils.isNullOrEmpty(route.getName())) {
                log.debug("context.next() not called, skipping handler for {} '{}'", (Object)route.getRequestMethod(), (Object)route.getUriPattern());
                continue;
            }
            log.debug("context.next() not called, skipping '{}' for {} '{}'", new Object[]{route.getName(), route.getRequestMethod(), route.getUriPattern()});
        }
    }

    @Override
    public RouteContext text() {
        this.response.text();
        return this;
    }

    @Override
    public RouteContext xml() {
        this.response.xml();
        return this;
    }

    @Override
    public RouteContext json() {
        this.response.json();
        return this;
    }

    @Override
    public RouteContext yaml() {
        this.response.yaml();
        return this;
    }

    @Override
    public RouteContext html() {
        this.response.html();
        return this;
    }

    @Override
    public RouteContext negotiateContentType() {
        this.response.contentType(this.request);
        return this;
    }

    @Override
    public RouteContext status(int code) {
        this.response.status(code);
        return this;
    }

    @Override
    public String uriFor(String nameOrUriPattern, Map<String, Object> parameters) {
        return this.application.getRouter().uriFor(nameOrUriPattern, parameters);
    }

    @Override
    public Messages getMessages() {
        return this.application.getMessages();
    }

    @Override
    public String getMessage(String key, Object ... args) {
        return this.application.getMessages().get(key, this, args);
    }

    @Override
    public String getMessage(String key, String language, Object ... args) {
        return this.application.getMessages().get(key, language, args);
    }

    @Override
    public Route getRoute() {
        return this.route;
    }

    @Override
    public PippoSettings getSettings() {
        return this.application.getPippoSettings();
    }

    protected void handleRoute(Route route) {
        if (StringUtils.isNullOrEmpty(route.getName())) {
            log.debug("Executing handler for {} '{}'", (Object)route.getRequestMethod(), (Object)route.getUriPattern());
        } else {
            log.debug("Executing '{}' for {} '{}'", new Object[]{route.getName(), route.getRequestMethod(), route.getUriPattern()});
        }
        this.route = route;
        route.getRouteHandler().handle(this);
    }
}

