/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core.gzip;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.pippo.core.Application;
import ro.pippo.core.Request;
import ro.pippo.core.RequestResponse;
import ro.pippo.core.RequestResponseFactory;
import ro.pippo.core.Response;
import ro.pippo.core.gzip.GZipResponseWrapper;
import ro.pippo.core.util.StringUtils;

public class GZipRequestResponseFactory
extends RequestResponseFactory {
    public GZipRequestResponseFactory(Application application) {
        super(application);
    }

    @Override
    public RequestResponse createRequestResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Response response;
        Request request = new Request(httpServletRequest, this.application);
        boolean acceptsGZipEncoding = this.acceptsGZipEncoding(httpServletRequest);
        if (acceptsGZipEncoding) {
            GZipResponseWrapper responseWrapper = new GZipResponseWrapper(httpServletResponse);
            response = new Response((HttpServletResponse)responseWrapper, this.application);
        } else {
            response = new Response(httpServletResponse, this.application);
        }
        return new RequestResponse(request, response);
    }

    protected boolean acceptsGZipEncoding(HttpServletRequest httpServletRequest) {
        String acceptEncoding = httpServletRequest.getHeader("accept-encoding");
        return !StringUtils.isNullOrEmpty(acceptEncoding) && (acceptEncoding.contains("gzip") || acceptEncoding.contains("*"));
    }
}

