/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import ro.pippo.core.Flash;
import ro.pippo.core.route.RouteDispatcher;

public class Session {
    private static final String FLASH = "flash";
    private HttpSession httpSession;

    public Session(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public String getId() {
        return this.httpSession.getId();
    }

    public void put(String name, Object value) {
        this.httpSession.setAttribute(name, value);
    }

    public <T> T get(String name) {
        return (T)this.httpSession.getAttribute(name);
    }

    public Enumeration<String> getNames() {
        return this.httpSession.getAttributeNames();
    }

    public <T> T remove(String name) {
        T t = this.get(name);
        this.httpSession.removeAttribute(name);
        return t;
    }

    public void invalidate() {
        this.httpSession.invalidate();
    }

    public void touch() {
        this.put("__touch", "DOES_NOT_MATTER");
        this.remove("__touch");
    }

    public Flash getFlash() {
        Flash flash = (Flash)this.get(FLASH);
        if (flash == null) {
            flash = new Flash();
            this.put(FLASH, flash);
        }
        return flash;
    }

    public boolean isNew() {
        return this.httpSession.isNew();
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public static Session get() {
        Object routeContext = RouteDispatcher.getRouteContext();
        return routeContext != null ? routeContext.getRequest().getSession(false) : null;
    }

    public Map<String, Object> getAll() {
        HashMap<String, Object> all = new HashMap<String, Object>();
        Enumeration<String> names = this.getNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            if (FLASH.equalsIgnoreCase(name)) continue;
            all.put(name, this.get(name));
        }
        return all;
    }
}

