/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.WebServerInitializer;
import ro.pippo.core.util.ServiceLocator;

public class PippoServletContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(PippoServletContextListener.class);
    private List<WebServerInitializer> initializers;

    public void contextInitialized(ServletContextEvent sce) {
        this.initializers = ServiceLocator.locateAll(WebServerInitializer.class);
        for (WebServerInitializer initializer : this.initializers) {
            try {
                log.debug("Found initializer '{}'", (Object)initializer.getClass().getName());
                initializer.init(sce.getServletContext());
            }
            catch (Exception e) {
                log.error("Failed to init '{}'", (Object)initializer.getClass().getName(), (Object)e);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        for (WebServerInitializer initializer : this.initializers) {
            try {
                log.debug("Found initializer '{}'", (Object)initializer.getClass().getName());
                initializer.destroy(sce.getServletContext());
            }
            catch (Exception e) {
                log.error("Failed to destroy '{}'", (Object)initializer.getClass().getName(), (Object)e);
            }
        }
    }
}

