/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Application;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.Request;
import ro.pippo.core.RequestResponse;
import ro.pippo.core.RequestResponseFactory;
import ro.pippo.core.Response;
import ro.pippo.core.route.RouteDispatcher;
import ro.pippo.core.util.PippoUtils;
import ro.pippo.core.util.StringUtils;

public class PippoServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(PippoServlet.class);
    public static final String APPLICATION_CLASS_PARAM = "applicationClassName";
    public static final String MODE_PARAM = "mode";
    private Application application;
    private RouteDispatcher routeDispatcher;

    public void setApplication(Application application) {
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    public void init(ServletConfig servletConfig) {
        String mode;
        if (System.getProperty("pippo.hideLogo") == null) {
            log.info(PippoUtils.getPippoLogo());
        }
        if (!StringUtils.isNullOrEmpty(mode = servletConfig.getInitParameter(MODE_PARAM))) {
            System.setProperty("pippo.mode", mode);
        }
        if (this.application == null) {
            this.createApplication(servletConfig);
            log.debug("Created application '{}'", (Object)this.application);
        }
        ServletContext servletContext = servletConfig.getServletContext();
        this.application.setServletContext(servletContext);
        if (servletContext.getAttribute("PIPPO_APPLICATION") == null) {
            servletContext.setAttribute("PIPPO_APPLICATION", (Object)this.application);
        }
        String contextPath = StringUtils.addStart(servletContext.getContextPath(), "/");
        this.application.getRouter().setContextPath(contextPath);
        log.debug("Serving application on context path '{}'", (Object)contextPath);
        log.debug("Initializing Route Dispatcher");
        this.routeDispatcher = new RouteDispatcher(this.application);
        this.routeDispatcher.init();
        String runtimeMode = this.application.getRuntimeMode().toString().toUpperCase();
        log.info("Pippo started ({})", (Object)runtimeMode);
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String applicationPath = this.application.getRouter().getContextPath() + httpServletRequest.getServletPath();
        this.application.getRouter().setApplicationPath(applicationPath);
        RequestResponseFactory requestResponseFactory = this.application.getRequestResponseFactory();
        RequestResponse requestResponse = requestResponseFactory.createRequestResponse(httpServletRequest, httpServletResponse);
        Request request = requestResponse.getRequest();
        Response response = requestResponse.getResponse();
        URI uri = URI.create(httpServletRequest.getRequestURL().toString());
        String requestUri = uri.getPath();
        String requestPath = request.getPath();
        log.trace("The relative path for '{}' is '{}'", (Object)requestUri, (Object)requestPath);
        log.debug("Request {} '{}'", (Object)request.getMethod(), (Object)requestPath);
        this.routeDispatcher.dispatch(request, response);
    }

    public void destroy() {
        if (this.application != null) {
            try {
                this.application.destroy();
                log.info("Pippo destroyed");
            }
            finally {
                this.application = null;
            }
        }
    }

    private void createApplication(ServletConfig servletConfig) {
        String applicationClassName = servletConfig.getInitParameter(APPLICATION_CLASS_PARAM);
        if (applicationClassName == null) {
            log.error("Servlet init param '{}' is missing", (Object)APPLICATION_CLASS_PARAM);
            throw new PippoRuntimeException("Cannot found application class name", new Object[0]);
        }
        try {
            Class<?> applicationClass = Class.forName(applicationClassName);
            this.application = (Application)applicationClass.newInstance();
        }
        catch (Exception e) {
            log.error("Cannot create application with className '{}'", (Object)applicationClassName, (Object)e);
            throw new PippoRuntimeException(e);
        }
    }
}

