/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.Application;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.RuntimeMode;
import ro.pippo.core.WebServer;
import ro.pippo.core.reload.ReloadClassLoader;
import ro.pippo.core.reload.ReloadWatcher;
import ro.pippo.core.route.ResourceRouting;
import ro.pippo.core.route.Route;
import ro.pippo.core.route.RouteGroup;
import ro.pippo.core.util.ServiceLocator;

public class Pippo
implements ResourceRouting,
ReloadWatcher.Listener {
    private static final Logger log = LoggerFactory.getLogger(Pippo.class);
    private Application application;
    private WebServer server;
    private volatile boolean running;
    private volatile boolean reloading;
    private ReloadWatcher reloadWatcher;

    public Pippo() {
        this.addShutdownHook();
    }

    public Pippo(Application application) {
        this.application = application;
        log.debug("Application '{}'", (Object)application);
        this.addShutdownHook();
    }

    public Application getApplication() {
        if (this.application == null) {
            this.initReloading();
            if (this.reloading) {
                log.info("Reload enabled");
                this.application = this.createApplication();
            } else {
                log.debug("Create a default application");
                this.application = new Application();
            }
        }
        return this.application;
    }

    public WebServer getServer() {
        if (this.server == null) {
            WebServer server = ServiceLocator.locate(WebServer.class);
            if (server == null) {
                throw new PippoRuntimeException("Cannot find a WebServer", new Object[0]);
            }
            this.setServer(server);
        }
        return this.server;
    }

    public Pippo setServer(WebServer server) {
        this.server = server;
        this.server.init(this.getApplication());
        return this;
    }

    public void start(int port) {
        this.getServer().setPort(port);
        this.start();
    }

    public void start() {
        if (this.running) {
            log.warn("Server is already started");
            return;
        }
        WebServer server = this.getServer();
        log.debug("Start server '{}'", (Object)server);
        server.start();
        this.running = true;
        if (this.reloading) {
            this.startReloadWatcher();
        }
    }

    public void stop() {
        if (!this.running) {
            log.debug("Server is not started");
            return;
        }
        if (this.reloading) {
            this.stopReloadWatcher();
        }
        WebServer server = this.getServer();
        log.debug("Stop server '{}'", (Object)server);
        server.stop();
        this.running = false;
    }

    @Override
    public void addRoute(Route route) {
        this.getApplication().addRoute(route);
    }

    @Override
    public void addRouteGroup(RouteGroup routeGroup) {
        this.getApplication().addRouteGroup(routeGroup);
    }

    public Pippo setFilterPath(String filterPath) {
        this.getServer().setPippoFilterPath(filterPath);
        return this;
    }

    public static Pippo send(String text) {
        Pippo pippo = new Pippo();
        pippo.GET("/", routeContext -> routeContext.send(text));
        pippo.start();
        return pippo;
    }

    protected void startReloadWatcher() {
        if (this.reloadWatcher == null) {
            this.reloadWatcher = this.createReloadWatcher();
        }
        this.reloadWatcher.start();
    }

    protected void stopReloadWatcher() {
        if (this.reloadWatcher != null) {
            this.reloadWatcher.stop();
            this.reloadWatcher = null;
        }
    }

    protected ReloadWatcher createReloadWatcher() {
        return new ReloadWatcher.Builder().addDirectory(System.getProperty("pippo.reload.targetClasses", "target/classes")).build(this);
    }

    @Override
    public void onEvent(ReloadWatcher.Event event, Path dir, Path path) {
        this.stop();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.application = this.createApplication();
        this.getServer().getPippoFilter().setApplication(this.application);
        this.start();
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    private Application createApplication() {
        final String targetClasses = System.getProperty("pippo.reload.targetClasses", "target/classes");
        log.debug("Target classes is '{}'", (Object)targetClasses);
        String rootPackageName = System.getProperty("pippo.reload.rootPackageName", "");
        log.debug("Root package name is '{}'", (Object)rootPackageName);
        ReloadClassLoader classLoader = new ReloadClassLoader(Pippo.class.getClassLoader(), rootPackageName){

            @Override
            protected InputStream getInputStream(String path) {
                Path resolvedPath = Paths.get(targetClasses, new String[0]).resolve(path);
                if (Files.notExists(resolvedPath, new LinkOption[0])) {
                    return null;
                }
                try {
                    return Files.newInputStream(resolvedPath, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new PippoRuntimeException(e);
                }
            }
        };
        Application application = ServiceLocator.locate(Application.class, classLoader);
        if (application != null) {
            return application;
        }
        String applicationClassName = System.getProperty("pippo.applicationClassName");
        if (applicationClassName == null) {
            throw new PippoRuntimeException("Cannot find the application class name", new Object[0]);
        }
        log.debug("Application class name is '{}'", (Object)applicationClassName);
        try {
            Class<?> applicationClass = classLoader.loadClass(applicationClassName);
            application = (Application)applicationClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return application;
    }

    private void initReloading() {
        String reloadEnabled = System.getProperty("pippo.reload.enabled");
        this.reloading = reloadEnabled != null ? Boolean.valueOf(reloadEnabled) : RuntimeMode.DEV == RuntimeMode.getCurrent();
    }
}

