/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.converters.Converter;
import ro.pippo.core.util.StringUtils;

public class ParameterValue
implements Serializable {
    private final Locale locale;
    private final String[] values;

    public ParameterValue(String ... values) {
        this(Locale.getDefault(), values);
    }

    public ParameterValue(Locale locale, String ... values) {
        this.locale = locale;
        this.values = values;
    }

    public boolean toBoolean() {
        return this.toBoolean(false);
    }

    public boolean toBoolean(boolean defaultValue) {
        if (this.isNull()) {
            return defaultValue;
        }
        switch (this.values[0]) {
            case "yes": 
            case "on": {
                return true;
            }
        }
        try {
            return Integer.parseInt(this.values[0]) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return Boolean.parseBoolean(this.values[0]);
        }
    }

    public byte toByte() {
        return this.toByte((byte)0);
    }

    public byte toByte(byte defaultValue) {
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        return Byte.parseByte(this.values[0]);
    }

    public short toShort() {
        return this.toShort((short)0);
    }

    public short toShort(short defaultValue) {
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        return Short.parseShort(this.values[0]);
    }

    public int toInt() {
        return this.toInt(0);
    }

    public int toInt(int defaultValue) {
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        return Integer.parseInt(this.values[0]);
    }

    public long toLong() {
        return this.toLong(0L);
    }

    public long toLong(long defaultValue) {
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        return Long.parseLong(this.values[0]);
    }

    public float toFloat() {
        return this.toFloat(0.0f);
    }

    public float toFloat(float defaultValue) {
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        try {
            Number number = this.getDecimalFormat().parse(this.values[0]);
            return number.floatValue();
        }
        catch (ParseException e) {
            throw new PippoRuntimeException(e, "Failed to parse '{}'", this.values[0]);
        }
    }

    public double toDouble() {
        return this.toDouble(0.0);
    }

    public double toDouble(double defaultValue) {
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        try {
            Number number = this.getDecimalFormat().parse(this.values[0]);
            return number.doubleValue();
        }
        catch (ParseException e) {
            throw new PippoRuntimeException(e, "Failed to parse '{}'", this.values[0]);
        }
    }

    public BigDecimal toBigDecimal() {
        return this.toBigDecimal(BigDecimal.ZERO);
    }

    public BigDecimal toBigDecimal(BigDecimal defaultValue) {
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        DecimalFormat formatter = this.getDecimalFormat();
        formatter.setParseBigDecimal(true);
        try {
            return (BigDecimal)formatter.parse(this.values[0]);
        }
        catch (ParseException e) {
            throw new PippoRuntimeException(e, "Failed to parse '{}'", this.values[0]);
        }
    }

    public UUID toUUID() {
        return this.toUUID(null);
    }

    public UUID toUUID(UUID defaultValue) {
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        return UUID.fromString(this.values[0]);
    }

    public Character toCharacter() {
        return this.toCharacter(Character.valueOf('\u0000'));
    }

    public Character toCharacter(Character defaultValue) {
        if (this.isNull() || this.values[0].length() == 0) {
            return defaultValue;
        }
        return Character.valueOf(this.values[0].charAt(0));
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String defaultValue) {
        if (this.isNull()) {
            return defaultValue;
        }
        return this.values[0];
    }

    public <T extends Enum<?>> T toEnum(Class<T> classOfT) {
        return this.toEnum(classOfT, null, true);
    }

    public <T extends Enum<?>> T toEnum(Class<T> classOfT, T defaultValue) {
        return this.toEnum(classOfT, defaultValue, true);
    }

    public <T extends Enum<?>> T toEnum(Class<T> classOfT, T defaultValue, boolean caseSensitive) {
        Enum[] constants;
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        int ordinal = Integer.MIN_VALUE;
        try {
            ordinal = Integer.parseInt(this.values[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Enum constant : constants = (Enum[])classOfT.getEnumConstants()) {
            if (constant.ordinal() == ordinal) {
                return (T)constant;
            }
            if (!(caseSensitive ? constant.name().equals(this.values[0]) : constant.name().equalsIgnoreCase(this.values[0]))) continue;
            return (T)constant;
        }
        return defaultValue;
    }

    public Set<String> toSet() {
        return this.toSet(Collections.emptySet());
    }

    public Set<String> toSet(Set<String> defaultValue) {
        List<String> list = this.toList();
        if (list.isEmpty()) {
            return defaultValue;
        }
        return Collections.unmodifiableSet(new HashSet<String>(list));
    }

    public <T> Set<T> toSet(Class<T> classOfT) {
        return this.toSet(classOfT, null);
    }

    public <T> Set<T> toSet(Class<T> classOfT, String pattern) {
        return (Set)this.toCollection(HashSet.class, classOfT, pattern);
    }

    public List<String> toList() {
        return this.toList(Collections.emptyList());
    }

    public List<String> toList(List<String> defaultValue) {
        if (this.isNull() || this.values.length == 1 && StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        if (this.values.length == 1) {
            String tmp = this.values[0];
            tmp = StringUtils.removeStart(tmp, "[");
            tmp = StringUtils.removeEnd(tmp, "]");
            return StringUtils.getList(tmp, "(,|\\|)");
        }
        return Arrays.asList(this.values);
    }

    public <T> List<T> toList(Class<T> classOfT) {
        return this.toList(classOfT, null);
    }

    public <T> List<T> toList(Class<T> classOfT, String pattern) {
        return (List)this.toCollection(ArrayList.class, classOfT, pattern);
    }

    public java.util.Date toDate(String pattern) {
        return this.toDate(null, pattern);
    }

    public java.util.Date toDate(java.util.Date defaultValue, String pattern) {
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        try {
            return dateFormat.parse(this.values[0]);
        }
        catch (ParseException e) {
            throw new PippoRuntimeException(e);
        }
    }

    public Date toSqlDate() {
        return this.toSqlDate(null);
    }

    public Date toSqlDate(Date defaultValue) {
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        return Date.valueOf(this.values[0]);
    }

    public Time toSqlTime() {
        return this.toSqlTime(null);
    }

    public Time toSqlTime(Time defaultValue) {
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        return Time.valueOf(this.values[0]);
    }

    public Timestamp toSqlTimestamp() {
        return this.toSqlTimestamp(null);
    }

    public Timestamp toSqlTimestamp(Timestamp defaultValue) {
        if (this.isNull() || StringUtils.isNullOrEmpty(this.values[0])) {
            return defaultValue;
        }
        return Timestamp.valueOf(this.values[0]);
    }

    public <T> T to(Class<T> classOfT) {
        return this.to(classOfT, null);
    }

    public <T> T to(Class<T> classOfT, String pattern) {
        if (classOfT == null) {
            return null;
        }
        if (classOfT.isArray()) {
            Class<?> componentType = classOfT.getComponentType();
            ParameterValue parameterValue = this.newParameterValuePlaceHolder();
            List<String> list = this.toList();
            Object array = Array.newInstance(componentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                String value;
                parameterValue.values[0] = value = list.get(i);
                Object object = parameterValue.toObject(componentType, pattern);
                Array.set(array, i, object);
            }
            return (T)array;
        }
        return (T)this.toObject(classOfT, pattern);
    }

    public <T, C extends Converter<T>> T convert(Class<C> converterClass, String pattern) {
        try {
            Converter converter = (Converter)converterClass.newInstance();
            return converter.getAsObject(this.values, this.locale, pattern);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new PippoRuntimeException(e, "Failed to convert", new Object[0]);
        }
    }

    public <X extends Collection<T>, T> X toCollection(Class<? extends Collection> collectionClass, Class<T> classOfT, String pattern) {
        if (collectionClass == null || classOfT == null) {
            return null;
        }
        try {
            Constructor<? extends Collection> constructor = collectionClass.getConstructor(new Class[0]);
            Collection collection = constructor.newInstance(new Object[0]);
            ParameterValue parameterValue = this.newParameterValuePlaceHolder();
            List<String> list = this.toList();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String value;
                parameterValue.values[0] = value = iterator.next();
                Object t = parameterValue.toObject(classOfT, pattern);
                collection.add(t);
            }
            return (X)collection;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PippoRuntimeException(e, "Failed to create collection", new Object[0]);
        }
    }

    private Object toObject(Class<?> type, String pattern) {
        if (type == String.class) {
            return this.toString();
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return this.toBoolean();
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return this.toByte();
        }
        if (type == Short.TYPE || type == Short.class) {
            return this.toShort();
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return this.toInt();
        }
        if (type == Long.TYPE || type == Long.class) {
            return this.toLong();
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(this.toFloat());
        }
        if (type == Double.TYPE || type == Double.class) {
            return this.toDouble();
        }
        if (type == Character.TYPE || type == Character.class) {
            return this.toCharacter();
        }
        if (type == BigDecimal.class) {
            return this.toBigDecimal();
        }
        if (type == UUID.class) {
            return this.toUUID();
        }
        if (type.isEnum()) {
            return this.toEnum(type);
        }
        if (pattern == null) {
            if (type == Date.class) {
                return this.toSqlDate();
            }
            if (type == Time.class) {
                return this.toSqlTime();
            }
            if (type == Timestamp.class) {
                return this.toSqlTimestamp();
            }
        } else if (java.util.Date.class.isAssignableFrom(type)) {
            java.util.Date date = this.toDate(pattern);
            if (type == java.util.Date.class) {
                return date;
            }
            if (type == Date.class) {
                return new Date(date.getTime());
            }
            if (type == Time.class) {
                return new Time(date.getTime());
            }
            if (type == Timestamp.class) {
                return new Timestamp(date.getTime());
            }
        }
        throw new PippoRuntimeException("Cannot convert '{}' to type '{}'", this.toString(), type);
    }

    public boolean isNull() {
        return this.values == null || this.values.length == 0 || this.values[0] == null;
    }

    public boolean isEmpty() {
        return this.values == null || this.values.length == 0 || StringUtils.isNullOrEmpty(this.values[0]);
    }

    public boolean isMultiValued() {
        return this.values != null && this.values.length > 1;
    }

    public String[] getValues() {
        return this.values;
    }

    private DecimalFormat getDecimalFormat() {
        return (DecimalFormat)DecimalFormat.getInstance(this.locale);
    }

    private ParameterValue newParameterValuePlaceHolder() {
        return new ParameterValue(this.locale, "PLACEHOLDER");
    }
}

