/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ro.pippo.core.util.StringUtils;

public class Flash
implements Iterable<Message>,
Serializable {
    private List<Message> messages = new ArrayList<Message>();

    public void add(int level, String message) {
        this.messages.add(new Message(level, message));
    }

    public List<String> get(int level) {
        if (this.messages.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Message message : this.messages) {
            if (!message.isLevel(level)) continue;
            list.add(message.getMessage());
        }
        return list;
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public boolean isEmpty(int level) {
        return this.get(level).isEmpty();
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }

    public void error(String message) {
        this.add(500, message);
    }

    public void error(String message, Object ... args) {
        this.add(500, StringUtils.format(message, args));
    }

    public boolean hasError() {
        return !this.isEmpty(500);
    }

    public String getError() {
        return this.hasError() ? this.get(500).get(0) : null;
    }

    public List<String> getErrorList() {
        return this.hasError() ? this.get(500) : Collections.emptyList();
    }

    public void success(String message) {
        this.add(300, message);
    }

    public void success(String message, Object ... args) {
        this.add(300, StringUtils.format(message, args));
    }

    public boolean hasSuccess() {
        return !this.isEmpty(300);
    }

    public String getSuccess() {
        return this.hasSuccess() ? this.get(300).get(0) : null;
    }

    public List<String> getSuccessList() {
        return this.hasSuccess() ? this.get(300) : Collections.emptyList();
    }

    public void warning(String message) {
        this.add(400, message);
    }

    public void warning(String message, Object ... args) {
        this.add(400, StringUtils.format(message, args));
    }

    public boolean hasWarning() {
        return !this.isEmpty(400);
    }

    public String getWarning() {
        return this.hasWarning() ? this.get(400).get(0) : null;
    }

    public List<String> getWarningList() {
        return this.hasWarning() ? this.get(400) : Collections.emptyList();
    }

    public void info(String message) {
        this.add(200, message);
    }

    public void info(String message, Object ... args) {
        this.add(200, StringUtils.format(message, args));
    }

    public boolean hasInfo() {
        return !this.isEmpty(200);
    }

    public String getInfo() {
        return this.hasInfo() ? this.get(200).get(0) : null;
    }

    public List<String> getInfoList() {
        return this.hasInfo() ? this.get(200) : Collections.emptyList();
    }

    public String toString() {
        return "FlashMessages{messages=" + this.messages + '}';
    }

    public static class Message
    implements Serializable {
        public static final int INFO = 200;
        public static final int SUCCESS = 300;
        public static final int WARNING = 400;
        public static final int ERROR = 500;
        private static final Map<Integer, String> levelStrings = new HashMap<Integer, String>();
        private int level;
        private String message;

        public Message(int level, String message) {
            this.level = level;
            this.message = message;
        }

        public int getLevel() {
            return this.level;
        }

        public String getLevelAsString() {
            return levelStrings.get(this.getLevel());
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isInfo() {
            return this.isLevel(200);
        }

        public boolean isSuccess() {
            return this.isLevel(300);
        }

        public boolean isWarning() {
            return this.isLevel(400);
        }

        public boolean isError() {
            return this.isLevel(500);
        }

        public boolean isLevel(int level) {
            return this.getLevel() == level;
        }

        public String toString() {
            return "Message{level=" + this.level + ", message='" + this.message + '\'' + '}';
        }

        static {
            levelStrings.put(200, "INFO");
            levelStrings.put(300, "SUCCESS");
            levelStrings.put(400, "WARNING");
            levelStrings.put(500, "ERROR");
        }
    }
}

