/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.Part;
import ro.pippo.core.util.IoUtils;

public class FileItem {
    private Part part;
    private String submittedFileName;

    public FileItem(Part part) {
        this.part = part;
    }

    public String getName() {
        return this.part.getName();
    }

    public String getSubmittedFileName() {
        if (this.submittedFileName == null) {
            String header = this.part.getHeader("Content-Disposition");
            if (header == null) {
                return null;
            }
            for (String headerPart : header.split(";")) {
                if (!headerPart.trim().startsWith("filename")) continue;
                this.submittedFileName = headerPart.substring(headerPart.indexOf(61) + 1).trim().replace("\"", "");
                break;
            }
        }
        return this.submittedFileName;
    }

    public long getSize() {
        return this.part.getSize();
    }

    public String getContentType() {
        return this.part.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        return this.part.getInputStream();
    }

    public void write(String fileName) throws IOException {
        this.part.write(fileName);
    }

    public void write(File file) throws IOException {
        try (InputStream inputStream = this.getInputStream();){
            IoUtils.copy(inputStream, file);
        }
    }

    public void delete() throws IOException {
        this.part.delete();
    }

    public String toString() {
        return "FileItem{name='" + this.getName() + '\'' + ", submittedFileName='" + this.getSubmittedFileName() + '\'' + ", size=" + this.getSize() + ", contentType='" + this.getContentType() + '\'' + '}';
    }
}

