/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.zeromq.Utils;
import zmq.util.Objects;

public class ZBeacon {
    public static final long DEFAULT_BROADCAST_INTERVAL = 1000L;
    public static final String DEFAULT_BROADCAST_HOST = "255.255.255.255";
    private static final byte[] DEFAULT_BRODACAST_ADDRESS = new byte[]{0, 0, 0, 0};
    private final BroadcastClient broadcastClient;
    private final BroadcastServer broadcastServer;
    private final AtomicReference<byte[]> prefix = new AtomicReference<byte[]>(new byte[0]);
    private final AtomicLong broadcastInterval = new AtomicLong(1000L);
    private final AtomicReference<Listener> listener = new AtomicReference();

    public ZBeacon(int port, byte[] beacon) {
        this(DEFAULT_BROADCAST_HOST, port, beacon);
    }

    public ZBeacon(String host, int port, byte[] beacon) {
        this(host, port, beacon, true);
    }

    public ZBeacon(String host, int port, byte[] beacon, boolean ignoreLocalAddress) {
        this(host, port, beacon, ignoreLocalAddress, false);
    }

    public ZBeacon(String host, int port, byte[] beacon, boolean ignoreLocalAddress, boolean blocking) {
        this(host, DEFAULT_BRODACAST_ADDRESS, port, beacon, 1000L, ignoreLocalAddress, blocking);
    }

    private ZBeacon(String host, byte[] serverAddress, int port, byte[] beacon, long broadcastInterval, boolean ignoreLocalAddress, boolean blocking) {
        Objects.requireNonNull(host, "Host cannot be null");
        Objects.requireNonNull(serverAddress, "Server address cannot be null");
        Objects.requireNonNull(beacon, "Beacon cannot be null");
        this.broadcastInterval.set(broadcastInterval);
        this.broadcastServer = new BroadcastServer(serverAddress, port, ignoreLocalAddress, blocking);
        this.broadcastServer.setDaemon(true);
        this.broadcastClient = new BroadcastClient(host, port, this.broadcastInterval, beacon);
        this.broadcastClient.setDaemon(true);
    }

    public void setUncaughtExceptionHandlers(Thread.UncaughtExceptionHandler clientHandler, Thread.UncaughtExceptionHandler serverHandler) {
        this.broadcastClient.setUncaughtExceptionHandler(clientHandler);
        this.broadcastServer.setUncaughtExceptionHandler(serverHandler);
    }

    public void start() {
        if (this.listener.get() != null) {
            this.broadcastServer.start();
        }
        this.broadcastClient.start();
    }

    public void stop() throws InterruptedException {
        if (this.broadcastClient != null) {
            this.broadcastClient.interrupt();
            this.broadcastClient.join();
        }
        if (this.broadcastServer != null) {
            this.broadcastServer.interrupt();
            this.broadcastServer.join();
        }
    }

    public void setPrefix(byte[] prefix) {
        this.prefix.set(prefix);
    }

    public byte[] getPrefix() {
        return this.prefix.get();
    }

    public void setListener(Listener listener) {
        this.listener.set(listener);
    }

    public Listener getListener() {
        return this.listener.get();
    }

    public long getBroadcastInterval() {
        return this.broadcastInterval.get();
    }

    public void setBroadcastInterval(long broadcastInterval) {
        this.broadcastInterval.set(broadcastInterval);
    }

    static /* synthetic */ byte[] access$000() {
        return DEFAULT_BRODACAST_ADDRESS;
    }

    private class BroadcastServer
    extends Thread {
        private final DatagramChannel handle;
        private final boolean ignoreLocalAddress;

        public BroadcastServer(byte[] serverAddress, int port, boolean ignoreLocalAddress, boolean blocking) {
            this.ignoreLocalAddress = ignoreLocalAddress;
            try {
                this.handle = DatagramChannel.open();
                this.handle.configureBlocking(blocking);
                DatagramSocket sock = this.handle.socket();
                sock.setReuseAddress(true);
                sock.bind(new InetSocketAddress(InetAddress.getByAddress(serverAddress), port));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        @Override
        public void run() {
            ByteBuffer buffer = ByteBuffer.allocate(65535);
            while (!BroadcastServer.interrupted()) {
                buffer.clear();
                try {
                    int read = buffer.remaining();
                    SocketAddress sender = this.handle.receive(buffer);
                    if (sender == null) continue;
                    InetAddress senderAddress = ((InetSocketAddress)sender).getAddress();
                    if (this.ignoreLocalAddress && (InetAddress.getLocalHost().getHostAddress().equals(senderAddress.getHostAddress()) || senderAddress.isAnyLocalAddress() || senderAddress.isLoopbackAddress())) continue;
                    int size = read - buffer.remaining();
                    this.handleMessage(buffer, size, senderAddress);
                }
                catch (ClosedChannelException ioException) {
                    break;
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
            this.handle.socket().close();
        }

        private void handleMessage(ByteBuffer buffer, int size, InetAddress from) {
            byte[] prefix = (byte[])ZBeacon.this.prefix.get();
            if (size < prefix.length) {
                return;
            }
            ByteBuffer buf = buffer.duplicate();
            buf.position(0);
            for (int i = 0; i < prefix.length; ++i) {
                if (buf.get() == prefix[i]) continue;
                return;
            }
            ((Listener)ZBeacon.this.listener.get()).onBeacon(from, Arrays.copyOf(buffer.array(), size));
        }
    }

    private static class BroadcastClient
    extends Thread {
        private DatagramChannel broadcastChannel;
        private final InetSocketAddress broadcastInetSocketAddress;
        private final AtomicLong broadcastInterval;
        private final byte[] beacon;

        public BroadcastClient(String host, int port, AtomicLong broadcastInterval, byte[] beacon) {
            this.broadcastInterval = broadcastInterval;
            this.beacon = beacon;
            try {
                this.broadcastInetSocketAddress = new InetSocketAddress(InetAddress.getByName(host), port);
            }
            catch (UnknownHostException unknownHostException) {
                throw new RuntimeException(unknownHostException);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                this.broadcastChannel = DatagramChannel.open();
                this.broadcastChannel.socket().setBroadcast(true);
                while (!BroadcastClient.interrupted()) {
                    try {
                        this.broadcastChannel.send(ByteBuffer.wrap(this.beacon), this.broadcastInetSocketAddress);
                        Thread.sleep(this.broadcastInterval.get());
                    }
                    catch (InterruptedException | ClosedByInterruptException interruptedException) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                        return;
                    }
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            finally {
                try {
                    this.broadcastChannel.close();
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
        }
    }

    public static interface Listener {
        public void onBeacon(InetAddress var1, byte[] var2);
    }

    public static class Builder {
        private String clientHost = "255.255.255.255";
        private byte[] serverAddr = ZBeacon.access$000();
        private int port;
        private long broadcastInterval = 1000L;
        private byte[] beacon;
        private boolean ignoreLocalAddress = true;
        private boolean blocking = false;

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder beacon(byte[] beacon) {
            this.beacon = beacon;
            return this;
        }

        public Builder client(String host) {
            this.clientHost = host;
            return this;
        }

        public Builder server(byte[] addr) {
            Utils.checkArgument(addr.length == 4 || addr.length == 16, "Server Address has to be 4 or 16 bytes long");
            this.serverAddr = addr;
            return this;
        }

        public Builder ignoreLocalAddress(boolean ignoreLocalAddress) {
            this.ignoreLocalAddress = ignoreLocalAddress;
            return this;
        }

        public Builder blocking(boolean blocking) {
            this.blocking = blocking;
            return this;
        }

        public Builder broadcastInterval(long broadcastInterval) {
            this.broadcastInterval = broadcastInterval;
            return this;
        }

        public ZBeacon build() {
            return new ZBeacon(this.clientHost, this.serverAddr, this.port, this.beacon, this.broadcastInterval, this.ignoreLocalAddress, this.blocking);
        }
    }
}

