/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.paginationlib;

import java.util.Collection;
import org.wiztools.paginationlib.PaginatedItems;
import org.wiztools.paginationlib.PaginatedItemsImpl;
import org.wiztools.paginationlib.PaginatedItemsSetters;

public final class PaginationUtil {
    private PaginationUtil() {
    }

    public static <T> PaginatedItems<T> getAllPaginatedItems(Collection<T> data) {
        return PaginationUtil.getPaginatedItems(data, data.size(), 1);
    }

    public static <T> PaginatedItems<T> getPaginatedItems(Collection<T> data, int pageSize, int page) {
        return PaginationUtil.getPaginatedItems(data, pageSize, page, new PaginatedItemsImpl(pageSize));
    }

    public static <T> PaginatedItems<T> getPaginatedItems(Collection<T> data, int pageSize, int page, PaginatedItemsSetters<T> out) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page-size cannot be less than 1");
        }
        if (page < 1) {
            throw new IllegalArgumentException("Page cannot be less than 1");
        }
        out.setPageSize(pageSize);
        out.setPage(page);
        if (data != null) {
            out.setTotalCount(data.size());
        } else {
            out.setTotalCount(0);
        }
        if (data != null) {
            int totalNumberOfPages = data.size() / pageSize + (data.size() % pageSize == 0 ? 0 : 1);
            out.setNumberOfPages(totalNumberOfPages);
        } else {
            out.setNumberOfPages(0);
        }
        if (out.getNumberOfPages() < page) {
            return out;
        }
        int startIndex = pageSize * (page - 1);
        int i = 0;
        int j = 0;
        for (T t : data) {
            if (i == startIndex) {
                out.addPaginatedItem(t);
                ++j;
            } else if (j > 0 && j < pageSize) {
                out.addPaginatedItem(t);
                ++j;
            }
            ++i;
        }
        return out;
    }
}

