/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.paginationlib;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.wiztools.paginationlib.PaginatedItemsSetters;

@XmlRootElement
public class PaginatedItemsImpl<T>
implements PaginatedItemsSetters<T> {
    @XmlElement
    private int page;
    @XmlElement
    private int pageSize;
    @XmlElement
    private int numberOfPages;
    @XmlElement
    private int totalCount;
    @XmlElementWrapper(name="items")
    @XmlElement(name="item")
    private final List<T> paginatedItems = new ArrayList<T>();

    public PaginatedItemsImpl(int pageSize) {
        this.pageSize = pageSize;
    }

    public PaginatedItemsImpl() {
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    @Override
    public void setNumberOfPages(int pages) {
        this.numberOfPages = pages;
    }

    @Override
    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public void addPaginatedItem(T item) {
        this.paginatedItems.add(item);
    }

    @Override
    public List<T> getPaginatedItems() {
        return this.paginatedItems;
    }

    public String toString() {
        return "PaginatedItemsImpl{page=" + this.page + "pageSize=" + this.pageSize + "totalCount=" + this.totalCount + "paginatedItems=" + this.paginatedItems + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaginatedItemsImpl other = (PaginatedItemsImpl)obj;
        if (this.page != other.page) {
            return false;
        }
        if (this.pageSize != other.pageSize) {
            return false;
        }
        if (this.totalCount != other.totalCount) {
            return false;
        }
        return this.paginatedItems == other.paginatedItems || this.paginatedItems != null && ((Object)this.paginatedItems).equals(other.paginatedItems);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.page;
        hash = 37 * hash + this.pageSize;
        hash = 37 * hash + this.totalCount;
        hash = 37 * hash + (this.paginatedItems != null ? ((Object)this.paginatedItems).hashCode() : 0);
        return hash;
    }
}

