package org.wiztools.paginationlib;

/**
 * This is used to create custom PaginatedItems to be used with PaginationUtil.
 * @see PaginationUtil#getPaginatedItems(java.util.Collection, int, int, org.wiztools.paginationlib.PaginatedItemsSetters) 
 * @author subwiz
 */
public interface PaginatedItemsSetters<T> extends PaginatedItems<T> {
    public void setPageSize(int pageSize);
    public void setPage(int page);
    public void setNumberOfPages(int pages);
    public void setTotalCount(int totalCount);
    public void addPaginatedItem(T item);
}
