package org.wiztools.paginationlib;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Default implementation of PaginatedItems.
 * @see PaginatedItems
 * @author subwiz
 */
@XmlRootElement
public class PaginatedItemsImpl<T> implements PaginatedItemsSetters<T> {
    @XmlElement private int page;
    @XmlElement private int pageSize;
    @XmlElement private int numberOfPages;
    @XmlElement private int totalCount;

    @XmlElementWrapper(name="items")
    @XmlElement(name="item")
    private final List<T> paginatedItems = new ArrayList<T>();

    public PaginatedItemsImpl(int pageSize) {
        this.pageSize = pageSize;
    }

    public PaginatedItemsImpl() {
        // do nothing!
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public int getPage() {
        return page;
    }

    @Override
    public int getPageSize() {
        return pageSize;
    }

    @Override
    public int getNumberOfPages() {
        return numberOfPages;
    }

    public void setNumberOfPages(int pages) {
        this.numberOfPages = pages;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    public int getTotalCount() {
        return totalCount;
    }

    public void addPaginatedItem(T item) {
        paginatedItems.add(item);
    }

    @Override
    public List<T> getPaginatedItems() {
        return paginatedItems;
    }

    @Override
    public String toString() {
        return "PaginatedItemsImpl{" + "page=" + page + "pageSize=" + pageSize + "totalCount=" + totalCount + "paginatedItems=" + paginatedItems + '}';
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final PaginatedItemsImpl<T> other = (PaginatedItemsImpl<T>) obj;
        if (this.page != other.page) {
            return false;
        }
        if (this.pageSize != other.pageSize) {
            return false;
        }
        if (this.totalCount != other.totalCount) {
            return false;
        }
        if (this.paginatedItems != other.paginatedItems && (this.paginatedItems == null || !this.paginatedItems.equals(other.paginatedItems))) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.page;
        hash = 37 * hash + this.pageSize;
        hash = 37 * hash + this.totalCount;
        hash = 37 * hash + (this.paginatedItems != null ? this.paginatedItems.hashCode() : 0);
        return hash;
    }

}
