package org.wiztools.paginationlib;

import java.io.Serializable;
import java.util.Collection;

/**
 * The implementation of this interface will contain the requested page content.
 * @author subwiz
 */
public interface PaginatedItems<T> extends Serializable {
    /**
     * @return The page that has been requested.
     */
    public int getPage();
    
    /**
     * @return The size of the page. The actual contents of the page may be smaller.
     */
    public int getPageSize();
    
    /**
     * @return The total number of pages available.
     */
    public int getNumberOfPages();
    
    /**
     * @return The total number of items available in the complete collection.
     */
    public int getTotalCount();
    
    /**
     * @return The collection of items belonging to this page.
     */
    public Collection<T> getPaginatedItems();
}
