/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.proxy;

import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

abstract class ExceptionCollector {
    private static final SQLException[] NO_EXCEPTIONS = new SQLException[0];
    private volatile Queue<SQLException> exceptions = null;

    ExceptionCollector() {
    }

    final void addException(SQLException exception) {
        if (!(exception instanceof SQLTimeoutException) && !(exception instanceof SQLTransactionRollbackException)) {
            this.getOrInit().offer(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Queue<SQLException> getOrInit() {
        Queue<SQLException> ex = this.exceptions;
        if (ex == null) {
            ExceptionCollector exceptionCollector = this;
            synchronized (exceptionCollector) {
                ex = this.exceptions;
                if (ex == null) {
                    this.exceptions = ex = new ConcurrentLinkedQueue<SQLException>();
                }
            }
        }
        return ex;
    }

    final SQLException[] getExceptions() {
        Queue<SQLException> ex = this.exceptions;
        if (ex == null) {
            return NO_EXCEPTIONS;
        }
        return ex.toArray(NO_EXCEPTIONS);
    }
}

