/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp.pool;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.vibur.dbcp.ViburConfig;

public interface Connector {
    public Connection connect() throws SQLException;

    public static final class Builder {
        private Builder() {
        }

        public static Connector buildConnector(ViburConfig config, String username, String password) {
            if (config.getExternalDataSource() == null) {
                return new Driver(config, username, password);
            }
            if (username != null) {
                return new DataSourceWithCredentials(config, username, password);
            }
            return new DataSource(config);
        }

        private static class DataSourceWithCredentials
        implements Connector {
            private final javax.sql.DataSource externalDataSource;
            private final String username;
            private final String password;

            private DataSourceWithCredentials(ViburConfig config, String username, String password) {
                this.externalDataSource = config.getExternalDataSource();
                this.username = username;
                this.password = password;
            }

            @Override
            public Connection connect() throws SQLException {
                return this.externalDataSource.getConnection(this.username, this.password);
            }
        }

        private static class DataSource
        implements Connector {
            private final javax.sql.DataSource externalDataSource;

            private DataSource(ViburConfig config) {
                this.externalDataSource = config.getExternalDataSource();
            }

            @Override
            public Connection connect() throws SQLException {
                return this.externalDataSource.getConnection();
            }
        }

        private static class Driver
        implements Connector {
            private final java.sql.Driver driver;
            private final String jdbcUrl;
            private final Properties driverProperties;

            private Driver(ViburConfig config, String username, String password) {
                this.driver = config.getDriver();
                this.jdbcUrl = config.getJdbcUrl();
                this.driverProperties = new Properties(config.getDriverProperties());
                this.driverProperties.setProperty("user", username);
                this.driverProperties.setProperty("password", password);
            }

            @Override
            public Connection connect() throws SQLException {
                return this.driver.connect(this.jdbcUrl, this.driverProperties);
            }
        }
    }
}

