/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.dbcp;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vibur.dbcp.ViburDBCPDataSource;
import org.vibur.dbcp.ViburMonitoringMBean;

public final class ViburMonitoring
implements ViburMonitoringMBean {
    private static final Logger logger = LoggerFactory.getLogger(ViburMonitoring.class);
    private final ViburDBCPDataSource dataSource;

    private ViburMonitoring(ViburDBCPDataSource dataSource) {
        this.dataSource = dataSource;
    }

    static void registerMBean(ViburDBCPDataSource dataSource) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(dataSource.getJmxName());
            if (!mbs.isRegistered(objectName)) {
                mbs.registerMBean(new ViburMonitoring(dataSource), objectName);
            } else {
                logger.warn(dataSource.getJmxName() + " is already registered.");
            }
        }
        catch (JMException e) {
            logger.warn("Unable to register mBean {}", (Object)dataSource.getJmxName(), (Object)e);
        }
    }

    static void unregisterMBean(ViburDBCPDataSource dataSource) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(dataSource.getJmxName());
            if (mbs.isRegistered(objectName)) {
                mbs.unregisterMBean(objectName);
            } else {
                logger.debug(dataSource.getJmxName() + " is not registered.");
            }
        }
        catch (JMException e) {
            logger.warn("Unable to unregister mBean {}", (Object)dataSource.getJmxName(), (Object)e);
        }
    }

    @Override
    public String getJdbcUrl() {
        return this.dataSource.getJdbcUrl();
    }

    @Override
    public String getDriverClassName() {
        return this.dataSource.getDriverClassName();
    }

    @Override
    public int getConnectionIdleLimitInSeconds() {
        return this.dataSource.getConnectionIdleLimitInSeconds();
    }

    @Override
    public void setConnectionIdleLimitInSeconds(int connectionIdleLimitInSeconds) {
        this.dataSource.setConnectionIdleLimitInSeconds(connectionIdleLimitInSeconds);
    }

    @Override
    public int getValidateTimeoutInSeconds() {
        return this.dataSource.getValidateTimeoutInSeconds();
    }

    @Override
    public void setValidateTimeoutInSeconds(int validateTimeoutInSeconds) {
        this.dataSource.setValidateTimeoutInSeconds(validateTimeoutInSeconds);
    }

    @Override
    public String getTestConnectionQuery() {
        return this.dataSource.getTestConnectionQuery();
    }

    @Override
    public void setTestConnectionQuery(String testConnectionQuery) {
        this.dataSource.setTestConnectionQuery(testConnectionQuery);
    }

    @Override
    public String getInitSQL() {
        return this.dataSource.getInitSQL();
    }

    @Override
    public void setInitSQL(String initSQL) {
        this.dataSource.setInitSQL(initSQL);
    }

    @Override
    public boolean isUseNetworkTimeout() {
        return this.dataSource.isUseNetworkTimeout();
    }

    @Override
    public int getPoolInitialSize() {
        return this.dataSource.getPoolInitialSize();
    }

    @Override
    public int getPoolMaxSize() {
        return this.dataSource.getPoolMaxSize();
    }

    @Override
    public int getPoolTaken() {
        return this.dataSource.getPool().taken();
    }

    @Override
    public int getPoolRemainingCreated() {
        return this.dataSource.getPool().remainingCreated();
    }

    @Override
    public boolean isPoolFair() {
        return this.dataSource.isPoolFair();
    }

    @Override
    public boolean isPoolEnableConnectionTracking() {
        return this.dataSource.isPoolEnableConnectionTracking();
    }

    @Override
    public int getReducerTimeIntervalInSeconds() {
        return this.dataSource.getReducerTimeIntervalInSeconds();
    }

    @Override
    public int getReducerSamples() {
        return this.dataSource.getReducerSamples();
    }

    @Override
    public boolean isAllowConnectionAfterTermination() {
        return this.dataSource.isAllowConnectionAfterTermination();
    }

    @Override
    public boolean isAllowUnwrapping() {
        return this.dataSource.isAllowUnwrapping();
    }

    @Override
    public long getConnectionTimeoutInMs() {
        return this.dataSource.getConnectionTimeoutInMs();
    }

    @Override
    public void setConnectionTimeoutInMs(long connectionTimeoutInMs) {
        this.dataSource.setConnectionTimeoutInMs(connectionTimeoutInMs);
    }

    @Override
    public int getLoginTimeoutInSeconds() {
        return this.dataSource.getLoginTimeoutInSeconds();
    }

    @Override
    public void setLoginTimeoutInSeconds(int loginTimeoutInSeconds) {
        this.dataSource.setLoginTimeoutInSeconds(loginTimeoutInSeconds);
    }

    @Override
    public long getAcquireRetryDelayInMs() {
        return this.dataSource.getAcquireRetryDelayInMs();
    }

    @Override
    public void setAcquireRetryDelayInMs(long acquireRetryDelayInMs) {
        this.dataSource.setAcquireRetryDelayInMs(acquireRetryDelayInMs);
    }

    @Override
    public int getAcquireRetryAttempts() {
        return this.dataSource.getAcquireRetryAttempts();
    }

    @Override
    public void setAcquireRetryAttempts(int acquireRetryAttempts) {
        this.dataSource.setAcquireRetryAttempts(acquireRetryAttempts);
    }

    @Override
    public int getStatementCacheMaxSize() {
        return this.dataSource.getStatementCacheMaxSize();
    }

    @Override
    public long getLogConnectionLongerThanMs() {
        return this.dataSource.getLogConnectionLongerThanMs();
    }

    @Override
    public void setLogConnectionLongerThanMs(long logConnectionLongerThanMs) {
        this.dataSource.setLogConnectionLongerThanMs(logConnectionLongerThanMs);
    }

    @Override
    public boolean isLogStackTraceForLongConnection() {
        return this.dataSource.isLogStackTraceForLongConnection();
    }

    @Override
    public void setLogStackTraceForLongConnection(boolean logStackTraceForLongConnection) {
        this.dataSource.setLogStackTraceForLongConnection(logStackTraceForLongConnection);
    }

    @Override
    public long getLogQueryExecutionLongerThanMs() {
        return this.dataSource.getLogQueryExecutionLongerThanMs();
    }

    @Override
    public void setLogQueryExecutionLongerThanMs(long logQueryExecutionLongerThanMs) {
        this.dataSource.setLogQueryExecutionLongerThanMs(logQueryExecutionLongerThanMs);
    }

    @Override
    public boolean isLogStackTraceForLongQueryExecution() {
        return this.dataSource.isLogStackTraceForLongQueryExecution();
    }

    @Override
    public void setLogStackTraceForLongQueryExecution(boolean logStackTraceForLongQueryExecution) {
        this.dataSource.setLogStackTraceForLongQueryExecution(logStackTraceForLongQueryExecution);
    }

    @Override
    public long getLogLargeResultSet() {
        return this.dataSource.getLogLargeResultSet();
    }

    @Override
    public void setLogLargeResultSet(long logLargeResultSet) {
        this.dataSource.setLogLargeResultSet(logLargeResultSet);
    }

    @Override
    public boolean isLogStackTraceForLargeResultSet() {
        return this.dataSource.isLogStackTraceForLargeResultSet();
    }

    @Override
    public void setLogStackTraceForLargeResultSet(boolean logStackTraceForLargeResultSet) {
        this.dataSource.setLogStackTraceForLargeResultSet(logStackTraceForLargeResultSet);
    }

    @Override
    public boolean isIncludeQueryParameters() {
        return this.dataSource.isIncludeQueryParameters();
    }

    @Override
    public void setIncludeQueryParameters(boolean includeQueryParameters) {
        this.dataSource.setIncludeQueryParameters(includeQueryParameters);
    }

    @Override
    public boolean isLogTakenConnectionsOnTimeout() {
        return this.dataSource.isLogTakenConnectionsOnTimeout();
    }

    @Override
    public boolean isLogAllStackTracesOnTimeout() {
        return this.dataSource.isLogAllStackTracesOnTimeout();
    }

    @Override
    public boolean isResetDefaultsAfterUse() {
        return this.dataSource.isResetDefaultsAfterUse();
    }

    @Override
    public Boolean getDefaultAutoCommit() {
        return this.dataSource.getDefaultAutoCommit();
    }

    @Override
    public Boolean getDefaultReadOnly() {
        return this.dataSource.getDefaultReadOnly();
    }

    @Override
    public String getDefaultTransactionIsolation() {
        return this.dataSource.getDefaultTransactionIsolation();
    }

    @Override
    public String getDefaultCatalog() {
        return this.dataSource.getDefaultCatalog();
    }

    @Override
    public boolean isClearSQLWarnings() {
        return this.dataSource.isClearSQLWarnings();
    }

    @Override
    public String showTakenConnections() {
        return this.dataSource.getTakenConnectionsStackTraces();
    }
}

